import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_SyncWebService_Contracts from './models/Curse.Friends.SyncWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class TwitchInteropService extends base {    

	getCheerEmoteConfig():Promise<any> {
		return this._get<any>(`twitch/bits/config`);
	}

	getCheerEmoteConfigForRegion(regionKey:string):Promise<any> {
		return this._getForRegion<any>(regionKey,`twitch/bits/config`);
	}

	getChatProperties(externalID:string):Promise<any> {
		return this._get<any>(`twitch/chat/${externalID}/properties`);
	}

	getChatPropertiesForRegion(regionKey:string, externalID:string):Promise<any> {
		return this._getForRegion<any>(regionKey,`twitch/chat/${externalID}/properties`);
	}

	getHostInfo(externalID:string):Promise<any> {
		return this._get<any>(`twitch/hosts/${externalID}`);
	}

	getHostInfoForRegion(regionKey:string, externalID:string):Promise<any> {
		return this._getForRegion<any>(regionKey,`twitch/hosts/${externalID}`);
	}



}