import * as Curse_Friends_NotificationContracts from './models/Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './models/Curse.Friends.Enums';
import * as Curse_Friends_ContactsWebService_Contracts from './models/Curse.Friends.ContactsWebService.Contracts';

import { BaseWebServiceClient as base } from './lib/BaseWebServiceClient';
export class UsersService extends base {    

	get(id:number):Promise<Curse_Friends_NotificationContracts.UserProfileNotification> {
		return this._get<Curse_Friends_NotificationContracts.UserProfileNotification>(`users/${id}`);
	}

	getForRegion(regionKey:string, id:number):Promise<Curse_Friends_NotificationContracts.UserProfileNotification> {
		return this._getForRegion<Curse_Friends_NotificationContracts.UserProfileNotification>(regionKey,`users/${id}`);
	}

	block(id:number):Promise<void> {
		return this._post<void>(`users/${id}/block`);
	}

	blockForRegion(regionKey:string, id:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`users/${id}/block`);
	}

	unblock(id:number):Promise<void> {
		return this._post<void>(`users/${id}/unblock`);
	}

	unblockForRegion(regionKey:string, id:number):Promise<void> {
		return this._postForRegion<void>(regionKey,`users/${id}/unblock`);
	}



}