import * as Curse_Voice_Contracts from './models/Curse.Voice.Contracts';

import { BaseWebSocketClient  } from './lib/BaseWebSocketClient';


export enum VoiceServiceContractType {
	ChatMessageRequest = -232462485,
	GetUsersRequest = -1589900211,
	JoinSessionRequest = 486664909,
	LeaveSessionRequest = 1348538754,
	ModDeafenUserRequest = 546259068,
	ModKickUserRequest = 1725746669,
	ModMuteUserRequest = -2044098371,
	ReJoinSessionRequest = 1922038087,
	SessionDescriptionAnswer = 528346488,
	TransmitEndRequest = -1218917461,
	TransmitStartRequest = 954399729,
	UpdateUserRequest = -1188142649,
	AddPendingUsersNotification = -1556424133,
	ChatMessageNotification = 822199438,
	ChatMessageResponse = 652186545,
	FailoverNotification = -307719853,
	GetUsersResponse = -884950340,
	JoinSessionResponse = -431543800,
	ModDeafenUserResponse = -262103360,
	ModKickUserResponse = 1909565151,
	ModMuteUserResponse = -176270521,
	RemovePendingUserNotification = -2051599782,
	SessionDescriptionOffer = 662358465,
	TransmitEndNotification = -1314746330,
	TransmitStartNotification = -1678184796,
	UserDisconnectNotification = -1491291229,
	UserJoinedNotification = 1230435885,
	UserLeftNotification = 1134735906,
	UserUpdatedNotification = 647681491,
	VoiceInstanceChangedNotification = 1533043215,

}

export interface VoiceServiceEvents {
    // Connection State
    connected(id: string): void;
    connecting(): void;
    disconnected(id: string): void;

    // Service Events
	addPendingUsersNotification(data: Curse_Voice_Contracts.AddPendingUsersNotification): void;
	chatMessageNotification(data: Curse_Voice_Contracts.ChatMessageNotification): void;
	chatMessageResponse(data: Curse_Voice_Contracts.ChatMessageResponse): void;
	failoverNotification(data: Curse_Voice_Contracts.FailoverNotification): void;
	getUsersResponse(data: Curse_Voice_Contracts.GetUsersResponse): void;
	joinSessionResponse(data: Curse_Voice_Contracts.JoinSessionResponse): void;
	modDeafenUserResponse(data: Curse_Voice_Contracts.ModDeafenUserResponse): void;
	modKickUserResponse(data: Curse_Voice_Contracts.ModKickUserResponse): void;
	modMuteUserResponse(data: Curse_Voice_Contracts.ModMuteUserResponse): void;
	removePendingUserNotification(data: Curse_Voice_Contracts.RemovePendingUserNotification): void;
	sessionDescriptionOffer(data: Curse_Voice_Contracts.SessionDescriptionOffer): void;
	transmitEndNotification(data: Curse_Voice_Contracts.TransmitEndNotification): void;
	transmitStartNotification(data: Curse_Voice_Contracts.TransmitStartNotification): void;
	userDisconnectNotification(data: Curse_Voice_Contracts.UserDisconnectNotification): void;
	userJoinedNotification(data: Curse_Voice_Contracts.UserJoinedNotification): void;
	userLeftNotification(data: Curse_Voice_Contracts.UserLeftNotification): void;
	userUpdatedNotification(data: Curse_Voice_Contracts.UserUpdatedNotification): void;
	voiceInstanceChangedNotification(data: Curse_Voice_Contracts.VoiceInstanceChangedNotification): void;
    
}

export abstract class VoiceService extends BaseWebSocketClient {

    protected events: VoiceServiceEvents;

    constructor(url: string, events: VoiceServiceEvents) {        
        this.events = events;
        this.events.connecting();

        super(url, {
			[VoiceServiceContractType.AddPendingUsersNotification]: (contract: any) => this.onAddPendingUsersNotification(contract),
			[VoiceServiceContractType.ChatMessageNotification]: (contract: any) => this.onChatMessageNotification(contract),
			[VoiceServiceContractType.ChatMessageResponse]: (contract: any) => this.onChatMessageResponse(contract),
			[VoiceServiceContractType.FailoverNotification]: (contract: any) => this.onFailoverNotification(contract),
			[VoiceServiceContractType.GetUsersResponse]: (contract: any) => this.onGetUsersResponse(contract),
			[VoiceServiceContractType.JoinSessionResponse]: (contract: any) => this.onJoinSessionResponse(contract),
			[VoiceServiceContractType.ModDeafenUserResponse]: (contract: any) => this.onModDeafenUserResponse(contract),
			[VoiceServiceContractType.ModKickUserResponse]: (contract: any) => this.onModKickUserResponse(contract),
			[VoiceServiceContractType.ModMuteUserResponse]: (contract: any) => this.onModMuteUserResponse(contract),
			[VoiceServiceContractType.RemovePendingUserNotification]: (contract: any) => this.onRemovePendingUserNotification(contract),
			[VoiceServiceContractType.SessionDescriptionOffer]: (contract: any) => this.onSessionDescriptionOffer(contract),
			[VoiceServiceContractType.TransmitEndNotification]: (contract: any) => this.onTransmitEndNotification(contract),
			[VoiceServiceContractType.TransmitStartNotification]: (contract: any) => this.onTransmitStartNotification(contract),
			[VoiceServiceContractType.UserDisconnectNotification]: (contract: any) => this.onUserDisconnectNotification(contract),
			[VoiceServiceContractType.UserJoinedNotification]: (contract: any) => this.onUserJoinedNotification(contract),
			[VoiceServiceContractType.UserLeftNotification]: (contract: any) => this.onUserLeftNotification(contract),
			[VoiceServiceContractType.UserUpdatedNotification]: (contract: any) => this.onUserUpdatedNotification(contract),
			[VoiceServiceContractType.VoiceInstanceChangedNotification]: (contract: any) => this.onVoiceInstanceChangedNotification(contract),

        });
    }

    protected onSocketOpen(id: string) {
        super.onSocketOpen(id);
        this.events.connected(id);
    }

    protected onSocketClose(id: string, e: CloseEvent) {
        super.onSocketClose(id, e);
        setTimeout(() => this.events.disconnected(id));
    }

	sendChatMessageRequest(contract:Curse_Voice_Contracts.ChatMessageRequest) {
		this.sendContract(VoiceServiceContractType.ChatMessageRequest, contract);
	}

	sendGetUsersRequest(contract:Curse_Voice_Contracts.GetUsersRequest) {
		this.sendContract(VoiceServiceContractType.GetUsersRequest, contract);
	}

	sendJoinSessionRequest(contract:Curse_Voice_Contracts.JoinSessionRequest) {
		this.sendContract(VoiceServiceContractType.JoinSessionRequest, contract);
	}

	sendLeaveSessionRequest(contract:Curse_Voice_Contracts.LeaveSessionRequest) {
		this.sendContract(VoiceServiceContractType.LeaveSessionRequest, contract);
	}

	sendModDeafenUserRequest(contract:Curse_Voice_Contracts.ModDeafenUserRequest) {
		this.sendContract(VoiceServiceContractType.ModDeafenUserRequest, contract);
	}

	sendModKickUserRequest(contract:Curse_Voice_Contracts.ModKickUserRequest) {
		this.sendContract(VoiceServiceContractType.ModKickUserRequest, contract);
	}

	sendModMuteUserRequest(contract:Curse_Voice_Contracts.ModMuteUserRequest) {
		this.sendContract(VoiceServiceContractType.ModMuteUserRequest, contract);
	}

	sendReJoinSessionRequest(contract:Curse_Voice_Contracts.ReJoinSessionRequest) {
		this.sendContract(VoiceServiceContractType.ReJoinSessionRequest, contract);
	}

	sendSessionDescriptionAnswer(contract:Curse_Voice_Contracts.SessionDescriptionAnswer) {
		this.sendContract(VoiceServiceContractType.SessionDescriptionAnswer, contract);
	}

	sendTransmitEndRequest(contract:Curse_Voice_Contracts.TransmitEndRequest) {
		this.sendContract(VoiceServiceContractType.TransmitEndRequest, contract);
	}

	sendTransmitStartRequest(contract:Curse_Voice_Contracts.TransmitStartRequest) {
		this.sendContract(VoiceServiceContractType.TransmitStartRequest, contract);
	}

	sendUpdateUserRequest(contract:Curse_Voice_Contracts.UpdateUserRequest) {
		this.sendContract(VoiceServiceContractType.UpdateUserRequest, contract);
	}

	onAddPendingUsersNotification(contract:Curse_Voice_Contracts.AddPendingUsersNotification) {
		 this.events.addPendingUsersNotification(contract);
	}

	onChatMessageNotification(contract:Curse_Voice_Contracts.ChatMessageNotification) {
		 this.events.chatMessageNotification(contract);
	}

	onChatMessageResponse(contract:Curse_Voice_Contracts.ChatMessageResponse) {
		 this.events.chatMessageResponse(contract);
	}

	onFailoverNotification(contract:Curse_Voice_Contracts.FailoverNotification) {
		 this.events.failoverNotification(contract);
	}

	onGetUsersResponse(contract:Curse_Voice_Contracts.GetUsersResponse) {
		 this.events.getUsersResponse(contract);
	}

	onJoinSessionResponse(contract:Curse_Voice_Contracts.JoinSessionResponse) {
		 this.events.joinSessionResponse(contract);
	}

	onModDeafenUserResponse(contract:Curse_Voice_Contracts.ModDeafenUserResponse) {
		 this.events.modDeafenUserResponse(contract);
	}

	onModKickUserResponse(contract:Curse_Voice_Contracts.ModKickUserResponse) {
		 this.events.modKickUserResponse(contract);
	}

	onModMuteUserResponse(contract:Curse_Voice_Contracts.ModMuteUserResponse) {
		 this.events.modMuteUserResponse(contract);
	}

	onRemovePendingUserNotification(contract:Curse_Voice_Contracts.RemovePendingUserNotification) {
		 this.events.removePendingUserNotification(contract);
	}

	onSessionDescriptionOffer(contract:Curse_Voice_Contracts.SessionDescriptionOffer) {
		 this.events.sessionDescriptionOffer(contract);
	}

	onTransmitEndNotification(contract:Curse_Voice_Contracts.TransmitEndNotification) {
		 this.events.transmitEndNotification(contract);
	}

	onTransmitStartNotification(contract:Curse_Voice_Contracts.TransmitStartNotification) {
		 this.events.transmitStartNotification(contract);
	}

	onUserDisconnectNotification(contract:Curse_Voice_Contracts.UserDisconnectNotification) {
		 this.events.userDisconnectNotification(contract);
	}

	onUserJoinedNotification(contract:Curse_Voice_Contracts.UserJoinedNotification) {
		 this.events.userJoinedNotification(contract);
	}

	onUserLeftNotification(contract:Curse_Voice_Contracts.UserLeftNotification) {
		 this.events.userLeftNotification(contract);
	}

	onUserUpdatedNotification(contract:Curse_Voice_Contracts.UserUpdatedNotification) {
		 this.events.userUpdatedNotification(contract);
	}

	onVoiceInstanceChangedNotification(contract:Curse_Voice_Contracts.VoiceInstanceChangedNotification) {
		 this.events.voiceInstanceChangedNotification(contract);
	}


}