import * as Curse_Friends_Enums from './Curse.Friends.Enums';
import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
export interface AccountRenameRequest {
	Username: string;
}
export interface PushPreferencesResponse {
	FriendMessagePushPreference: Curse_Friends_Enums.PushNotificationPreference;
	GroupMessagePushPreference: Curse_Friends_Enums.PushNotificationPreference;
	FriendRequestPushEnabled: boolean;
	MentionsPushEnabled: boolean;
}
export interface PushNotificationPreferencesRequest {
	GroupMessagePushPreference: Curse_Friends_Enums.PushNotificationPreference;
	FriendMessagePushPreference: Curse_Friends_Enums.PushNotificationPreference;
	FriendRequestPushEnabled: boolean;
	MentionsPushEnabled?: boolean;
}
export interface SetIdleRequest {
	MachineKey: string;
}
export interface SetActiveRequest {
	MachineKey: string;
}
export interface ChangeStatusRequest {
	MachineKey: string;
	Status: Curse_Friends_Enums.UserConnectionStatus;
	CustomStatusMessage: string;
}
export interface ChangeGameStatusRequest {
	GameID: number;
	GameState: number;
	GameStatusMessage: string;
	IsRunning: boolean;
	MachineKey: string;
}
export interface ChangeWatchingStatusRequest {
	ChannelID: string;
	MachineKey: string;
	IsWatching: boolean;
}
export interface ChangeProfileRequest {
	Name: string;
	City: string;
	State: string;
	CountryCode: string;
	AboutMe: string;
}
export enum ChangePasswordStatus {
	InvalidOldPassword = 0,
	InvalidNewPassword = 1,
	PasswordMismatch = 2,
	Success = 3,
	Error = 4,
}
export interface ChangePasswordRequest {
	OldPassword: string;
	NewPassword: string;
	ConfirmNewPassword: string;
}
export enum ChangeEmailStatus {
	Successful = 0,
	EmailInUse = 1,
	InvalidEmail = 2,
	Error = 3,
	InvalidPassword = 4,
}
export interface ChangeEmailRequest {
	Email: string;
	Password: string;
}
export interface GetChangeUsernameAvailabilityResponse {
	Availability: ChangeUsernameAvailability;
	MillisecondsBeforeRetry: number;
}
export enum ChangeUsernameAvailability {
	NotAvailable = 0,
	Available = 1,
}
export interface ChangeUsernameRequest {
	Password: string;
	NewUsername: string;
}
export interface ChangeClientSettingsRequest {
	GlobalSettings: string;
	WebSettings: string;
	DesktopSettings: string;
	MobileSettings: string;
}
export interface AccountEntitlementsResponse {
	Entitlements: AccountEntitlement[];
}
export interface AccountEntitlement {
	Identifier: string;
	IsActive: boolean;
	ExpirationTimestamp: number;
}
export interface EmoteContract {
	EmoteID: number;
	EmoteSet: number;
	Text: string;
	Url: string;
	EmoteHeight: number;
	EmoteWidth: number;
}
export interface GetTwitchEmotesResponse {
	CanUseEmotes: boolean;
	Emotes: EmoteContract[];
}
export interface GetTwitchTokenResponse {
	Status: GetTwitchTokenStatus;
	NeedsReauthentication: boolean;
	Token: string;
	ExternalID: string;
	ExternalUsername: string;
	ExternalDisplayName: string;
}
export enum GetTwitchTokenStatus {
	Success = 0,
	NoAccount = 1,
}

