import * as Curse_Friends_Enums from './Curse.Friends.Enums';
export interface ClientBugReportAttachmentContract {
	AttachmentID: number;
	BugReportID: number;
	Filename: string;
	FileLength: number;
	FileContents: any;
	CreatedTimestamp: number;
}
export interface BugReport {
	ClientVersion: string;
	Title: string;
	Type: BugReportType;
	StackTraceHash?: number;
	UserSettings: string;
	SystemInformation: string;
	IncompatibleProcesses: string;
	GameConfiguration: string;
	LogData: string;
	Attachments: BugReportAttachment[];
	ExceptionDetails: string;
	ApplicationLocation: string;
	Message: string;
	LastAttemptedVoiceHostID?: number;
	OverlayExitCode?: number;
	OverlayGameState?: any;
	RunningProcesses: BugReportProcess[];
	Platform: Curse_Friends_Enums.DevicePlatform;
	CallQuality?: number;
	TimeConfiguration: string;
}
export enum BugReportType {
	CrashReport = 1,
	BugOrDefect = 2,
	FeatureSuggestion = 3,
	LoginIssue = 4,
	StartupIssue = 5,
	OtherIssue = 6,
	AutoReport = 7,
	GameCrash = 8,
	CallQuality = 9,
	PostiveFeedback = 10,
	NegativeFeedback = 11,
}
export interface BugReportAttachment {
	FileName: string;
	FileContents: any;
}
export interface BugReportProcess {
	ID: number;
	FullName: string;
	Name: string;
	StartTime: Date;
	Type: BugReportProcessType;
}
export enum BugReportProcessType {
	Executable = 1,
	Library = 2,
}
export interface Feedback {
	FeedbackType: FeedbackType;
	ClientVersion: string;
	Platform: Curse_Friends_Enums.DevicePlatform;
	LogData: string;
	Message: string;
	LastAttemptedVoiceHostID?: number;
}
export enum FeedbackType {
	Positive = 0,
	Negative = 1,
}
export interface UserReport {
	Type: Curse_Friends_Enums.UserReportType;
	Reason: Curse_Friends_Enums.UserReportReason;
	UserID: number;
	Description: string;
}

