import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
export interface VoiceHostCallbackRequest {
	GroupID: string;
	UserIDs: number[];
	ChangeType: VoiceHostCallbackType;
	InviteCode: string;
}
export enum VoiceHostCallbackType {
	CallStarted = 0,
	CallEnded = 1,
	UsersJoined = 2,
	UsersLeft = 3,
}
export interface KickUsersFromCallRequest {
	RequestorUserID: number;
	GroupID: string;
	UserIDs: number[];
	Reason: KickReason;
}
export enum KickReason {
	UserRemoved = 0,
	UserLeft = 1,
}
export interface CheckVoicePermissionsRequest {
	GroupID: string;
	RequestingUserID: number;
	AffectedUserID: number;
}
export interface GetModerationStatusResponse {
	Permissions: VoicePermissions;
	IsMuted: boolean;
	IsDeafened: boolean;
}
export interface VoicePermissions {
	BestRoleRank: number;
	CanSpeak: boolean;
	CanModKick: boolean;
	CanModMute: boolean;
	CanModDeafen: boolean;
}
export interface ConversationCallRequest {
	ClientVersion: string;
	Force: boolean;
	SendInvitation: boolean;
	Mode: Curse_Friends_Enums.CallMode;
}
export interface AdHocCallRequest {
	GameID?: number;
	UserDisplayName: string;
	ClientVersion: string;
}
export interface AutoMatchCallRequest {
	GameID: number;
	UserDisplayName: string;
	ClientVersion: string;
	AutoMatchKey: number;
}
export interface AdHocCallDisplayDetailsResponse {
	UserID: number;
	Username: string;
	InviteCode: string;
	Timestamp: number;
}
export interface DeafenUserRequest {
	UserID: number;
	Mute: boolean;
}
export interface MoveUserRequest {
	TargetGroupID: string;
}

