import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
export interface FriendListSearchRequest {
	Identity: Curse_Friends_NotificationContracts.FriendHintContract;
	FriendsList: Curse_Friends_NotificationContracts.FriendHintContract[];
}
export interface FriendListMultiSearchRequest {
	FriendLists: FriendListSearchRequest[];
}
export interface FriendshipRequest {
	KnownIdentity: string;
	InvitationMessage: string;
	IsFromSuggestion: boolean;
}
export interface FriendOfFriendDetails {
	UserID: number;
	Username: string;
}
export interface FriendSearchResponse {
	CharacterMatches: Curse_Friends_NotificationContracts.CharacterSearchContract[];
	EmailMatches: Curse_Friends_NotificationContracts.EmailSearchContract[];
	UserMatches: Curse_Friends_NotificationContracts.UsernameSearchContract[];
	PlatformMatches: Curse_Friends_NotificationContracts.PlatformSearchContract[];
	ElapsedMilliseconds: number;
	Status: FriendSearchStatus;
}
export enum FriendSearchStatus {
	Unknown = 0,
	Successful = 1,
	Error = 2,
	Invalid = 3,
}
export interface ChangeFriendshipPreferencesRequest {
	Preference: Curse_Friends_Enums.NotificationPreference;
	FilterSet: string[];
}
export interface ContactsResponse {
	Friends: Curse_Friends_NotificationContracts.FriendshipContract[];
	Groups: Curse_Friends_NotificationContracts.GroupNotification[];
	PrivateConversations: Curse_Friends_NotificationContracts.PrivateConversationContract[];
	BlockedUsers: Curse_Friends_NotificationContracts.BlockedUserContract[];
}
export interface ContactUrlResponse {
	ContactID: string;
	ConversationID: string;
	Title: string;
	Url: string;
	Type: ContactUrlType;
	GroupContact: GroupContactUrlResponse;
}
export enum ContactUrlType {
	Group = 0,
	Server = 1,
	Friend = 2,
}
export interface GroupContactUrlResponse {
	Subtype: Curse_Friends_Enums.GroupSubType;
	Description: string;
	IsPublic: boolean;
	MemberCount: number;
}

