import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
export interface ActiveGiveawayResponse {
	Giveaway: Curse_Friends_NotificationContracts.GroupGiveawayNotification;
	Rolls: Curse_Friends_NotificationContracts.GroupGiveawayRollContract[];
	PendingWinner: PendingWinnerContract;
	Entered: boolean;
}
export interface PendingWinnerContract {
	GroupID: string;
	GiveawayID: number;
	UserID: number;
	Username: string;
	SecondsUntilExpires: number;
	Timestamp: number;
}
export interface CreateGiveawayRequest {
	Title: string;
	AutoEnterActiveUsers: boolean;
	AutoEnterRoles: number[];
	AutoClaimRoles: number[];
	RollsBeforeWinner: number;
	RoleBonuses: { [key: number]: number };
	ResponseWindowSeconds: number;
	RequiredRoles: number[];
	AllowRepeatWinners: boolean;
	IgnoredUsers: number[];
	SharingBonus: number;
	IncludeOfflineMembers: boolean;
}
export interface GroupGiveawayRollResult {
	GroupID: string;
	GiveawayID: number;
	Title: string;
	RollTimestamp: number;
	TotalEntries: number;
	WinnerUserID: number;
	WinnerUsername: string;
	ValidWinner: boolean;
	ClaimedPrize: boolean;
}
export interface GetGiveawayHistoryRequest {
	PageSize?: number;
	PageNumber?: number;
}

