import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
export interface ApiGroupSearchContract {
	Model: Curse_Friends_NotificationContracts.GroupSearchModelContract;
	AvatarUrl: string;
	GroupCoverUrl: string;
}
export interface SearchServersRequest {
	Query: string;
	PageNumber?: number;
	PageSize?: number;
	GroupTitle: string;
	OwnerUsername: string;
	MinMemberCount?: number;
	MaxMemberCount?: number;
	Tags: Curse_Friends_Enums.GroupSearchTag[];
	IsPublic?: boolean;
	Games: number[];
	SortType?: Curse_Friends_Enums.GroupSearchSortType;
	SortAscending?: boolean;
	IsFeatured?: boolean;
	IsStreaming?: boolean;
	IncludeInappropriateContent: boolean;
	SubType?: Curse_Friends_Enums.GroupSubType;
}
export interface MarkInappropriateRequest {
	ServerID: string;
	Reason: string;
}
export interface CreateGroupRequest {
	RecipientsUserIDs: number[];
	Title: string;
	OwnerRoleName: string;
	MemberRoleName: string;
}
export interface ModifyGroupSettingsRequest {
	Title: string;
	MessageOfTheDay: string;
	ForcePushToTalk?: boolean;
}
export interface GroupMemberSearchRequest {
	Username: string;
	RoleID?: number;
	PageSize?: number;
	Page?: number;
	SortType?: Curse_Friends_Enums.GroupMemberSearchSortType;
	SortAscending?: boolean;
}
export interface ToggleFavoriteRequest {
	GroupID: string;
	IsFavorite: boolean;
}
export interface GroupMemberNicknameRequest {
	Nickname: string;
}
export interface BulkGroupNotificationPreferences {
	GroupID: string;
	Preference: Curse_Friends_Enums.NotificationPreference;
	FilterSet: string[];
}
export interface GroupNotificationPreferences {
	Preference: Curse_Friends_Enums.NotificationPreference;
	FilterSet: string[];
}
export interface SearchGroupEventsRequest {
	UsernameQuery: string;
	IncludedCategories: Curse_Friends_Enums.GroupEventCategory[];
	ExcludedCategories: Curse_Friends_Enums.GroupEventCategory[];
	IncludedEventTypes: Curse_Friends_Enums.GroupEventType[];
	ExcludedEventTypes: Curse_Friends_Enums.GroupEventType[];
	PageSize?: number;
	PageNumber?: number;
	SortAscending?: boolean;
	SortType?: Curse_Friends_Enums.GroupEventSearchSortType;
}
export interface GetInvitationDisplayDetailsResponse {
	InviteCode: string;
	GroupID: string;
	GroupTitle: string;
	ChannelID: string;
	ChannelTitle: string;
	CreatorID: number;
	CreatorUsername: string;
	MemberCount: number;
	Description: string;
}
export interface GroupInvitationRedeemResponse {
	Group: Curse_Friends_NotificationContracts.GroupNotification;
	ChannelID: string;
}
export interface DiscoverResponse {
	Groups: Curse_Friends_NotificationContracts.GroupSearchModelContract[];
	ExternalCommunities: Curse_Friends_NotificationContracts.ExternalCommunitySearchModelContract[];
}
export interface DiscoverRequest {
	Query: string;
	PageNumber?: number;
	PageSize?: number;
	GroupTitle: string;
	OwnerUsername: string;
	MinMemberCount?: number;
	MaxMemberCount?: number;
	Tags: Curse_Friends_Enums.GroupSearchTag[];
	IsPublic?: boolean;
	Games: number[];
	SortType?: DiscoverSortType;
	SortAscending?: boolean;
	IsFeatured?: boolean;
	IsStreaming?: boolean;
	IncludeInappropriateContent: boolean;
	SubType?: Curse_Friends_Enums.GroupSubType;
}
export enum DiscoverSortType {
	Default = 0,
	Title = 1,
	MemberCount = 2,
	DateLive = 3,
	DateFeatured = 4,
}
export interface ServerCreationOptionsResponse {
	SyncAvailable: boolean;
	SyncByDefault: boolean;
	AvatarUrl: string;
	ServerTitle: string;
	ServerUrl: string;
	PublicAvailable: boolean;
	PublicByDefault: boolean;
}
export interface CreateServerRequest {
	Title: string;
	TextChannelTitle: string;
	VoiceChannelTitle: string;
	OwnerRoleName: string;
	GuestRoleName: string;
	ModeratorRoleName: string;
	IsPublic: boolean;
	IsSynced: boolean;
}
export interface CreateStreamerCommunityGroupResponse {
	Group: Curse_Friends_NotificationContracts.GroupNotification;
	SyncedStreams: SyncResults[];
}
export interface SyncResults {
	StreamID: string;
	Type: Curse_Friends_Enums.AccountType;
	Succeeded: boolean;
	Followers: number;
	Subscribers: number;
}
export interface CreateStreamerCommunityGroupRequest {
	ServerName: string;
	DefaultTextChannelName: string;
	DefaultVoiceChannelName: string;
	OwnerRoleName: string;
	GuestRoleName: string;
	IsPublic: boolean;
	CustomUrl: string;
	SyncedStreams: SyncedStreamInfo[];
}
export interface SyncedStreamInfo {
	ExternalAccountID: string;
	Type: Curse_Friends_Enums.AccountType;
	PremiumChannelName: string;
}
export interface CreateGuildCommunityRequest {
	Title: string;
	IsPublic: boolean;
	Games: number[];
	OwnerRole: GuildCommunityRoleContract;
	GuestRole: GuildCommunityRoleContract;
	AdditionalRoles: GuildCommunityRoleContract[];
	GeneralChatName: string;
	OfficerChatName: string;
	PveChatName: string;
	PvpChatName: string;
}
export interface GuildCommunityRoleContract {
	Name: string;
	Color: number;
	IsOfficer: boolean;
	HasBadge: boolean;
	VanityBadge: number;
}
export interface CreateSyncedGuildServerResponse {
	Results: SyncedGuildResult[];
	Group: Curse_Friends_NotificationContracts.GroupNotification;
	Invitation: Curse_Friends_NotificationContracts.GroupInvitationNotification;
}
export interface SyncedGuildResult {
	Success: boolean;
	Type: Curse_Friends_Enums.AccountType;
	GameRegion: number;
	GameServer: string;
	GuildName: string;
}
export interface CreateSyncedGuildServerRequest {
	Subtype: Curse_Friends_Enums.GroupSubType;
	DefaultVoiceChannelName: string;
	Guilds: SyncedGuild[];
	AvatarUrl: string;
	Title: string;
	IsPublic: boolean;
	Games: number[];
	OwnerRole: GuildCommunityRoleContract;
	GuestRole: GuildCommunityRoleContract;
	AdditionalRoles: GuildCommunityRoleContract[];
	GeneralChatName: string;
	OfficerChatName: string;
	PveChatName: string;
	PvpChatName: string;
}
export interface SyncedGuild {
	Type: Curse_Friends_Enums.AccountType;
	GameRegion: number;
	GameServer: string;
	Name: string;
	RolesToCreate: SyncedGuildRole[];
}
export interface SyncedGuildRole {
	Tag: Curse_Friends_Enums.GroupRoleTag;
	Name: string;
	Color: number;
	IsOfficer: boolean;
	HasBadge: boolean;
	VanityBadge: number;
}
export enum ValidateUrlStatus {
	Invalid = 0,
	Taken = 1,
	Available = 2,
}
export interface ServerGeneralSettingsContract {
	Title: string;
	AfkChannel?: string;
	AfkTimeMinutes: number;
	VoiceRegion: Curse_Friends_Enums.VoiceRegion;
	IsPublic: boolean;
	ChatThrottleSeconds: number;
	ChatThrottleEnabled: boolean;
}
export interface ServerSearchSettingsContract {
	IsSearchable: boolean;
	Description: string;
	SearchTags: Curse_Friends_Enums.GroupSearchTag[];
	Games: number[];
	MatchAllGames: boolean;
}
export interface CreateChannelRequest {
	Title: string;
	Mode: Curse_Friends_Enums.GroupMode;
	IsPublic: boolean;
	AccessRoles: number[];
	DisplayCategory: GroupDisplayCategory;
	HideNoAccess: boolean;
	HideCallMembersNoAccess: boolean;
}
export interface GroupDisplayCategory {
	ID: string;
	Name: string;
	Rank: number;
}
export interface ModifyChannelSettingsRequest {
	Title: string;
	MessageOfTheDay: string;
	AllowTemporaryChildGroups?: boolean;
	ForcePushToTalk?: boolean;
	IsPublic: boolean;
	AccessRoles: number[];
	HideNoAccess: boolean;
	HideCallMembersNoAccess: boolean;
}
export interface ReorganizeGroupRequest {
	DisplayCategories: GroupDisplayCategory[];
	ChangedGroups: GroupDisplayOrder[];
}
export interface GroupDisplayOrder {
	GroupID: string;
	ParentID: string;
	DisplayOrder: number;
	CategoryID: string;
}
export interface AddEmoticonRequest {
	Regex: string;
	Url: string;
	RequiredRoles: number[];
}
export interface GroupRoleDetails {
	Role: Curse_Friends_NotificationContracts.GroupRoleNotification;
	EffectivePermissions: { [key: string]: number };
	Permissions: { [key: string]: { [key: number]: Curse_Friends_Enums.GroupPermissionState } };
}
export interface CreateGroupRoleRequest {
	Name: string;
	VanityColor: number;
	VanityBadge: number;
	HasCustomVanityBadge: boolean;
	Permissions: Curse_Friends_Enums.GroupPermissions;
}
export interface ModifyGroupRoleRequest {
	Name: string;
	VanityColor: number;
	VanityBadge: number;
	HasCustomVanityBadge: boolean;
	Permissions: { [key: number]: Curse_Friends_Enums.GroupPermissionState };
}
export interface ModifyGroupRolePermissionsRequest {
	PermissionsChanges: { [key: number]: Curse_Friends_Enums.GroupPermissionState };
}
export interface CreateGroupInviteRequest {
	ChannelID: string;
	AutoRemoveMembers: boolean;
	LifespanMinutes: number;
	MaxUses: number;
	AdminDescription: string;
	ReadableWordCategory: GroupInvitationReadableWordCategory;
}
export enum GroupInvitationReadableWordCategory {
	None = 0,
	WorldOfWarcraft = 1,
}
export interface GroupBannedUserContract {
	GroupID: string;
	GroupTitle: string;
	UserID: number;
	Username: string;
	RequestorUserID: number;
	RequestorUsername: string;
	StatusTimestamp: number;
	Reason: string;
	IsBanned: boolean;
	MaskedIPAddress: string;
}
export interface SearchBannedUsersRequest {
	PageNumber?: number;
	PageSize?: number;
	Query: string;
	Username: string;
	RequestorUsername: string;
	Reason: string;
	SortType?: Curse_Friends_Enums.GroupBannedUserSortType;
	SortAscending?: boolean;
}
export interface BanUserRequest {
	UserID: number;
	Reason: string;
	BanIP: boolean;
	MessageDeleteMode: BanUserMessageDeleteMode;
}
export enum BanUserMessageDeleteMode {
	None = 0,
	LastDay = 1,
	LastWeek = 2,
	All = 3,
}

