import * as Curse_Friends_Enums from './Curse.Friends.Enums';
export interface IdentityMergeStateContract {
	CurseUserID: number;
	DisplayName: string;
	FailureReason: Curse_Friends_Enums.IdentityMergeFailureReason;
	Status: Curse_Friends_Enums.IdentityMergeStatus;
	TwitchUserID: string;
	Username: string;
}
export interface LoginResponse {
	Status: LoginStatus;
	StatusMessage: string;
	Session: LoginSession;
	Timestamp: number;
	TwitchUsernameReservationToken: string;
}
export enum LoginStatus {
	Success = 1,
	UnauthorizedLogin = 3,
	InvalidPassword = 4,
	UnknownUsername = 5,
	UnknownEmail = 6,
	CorruptLibrary = 102,
	SubscriptionMismatch = 104,
	SubscriptionExpired = 105,
	MissingGrant = 108,
	GeneralError = 1000,
}
export interface LoginSession {
	UserID: number;
	Username: string;
	DisplayName: string;
	SessionID: string;
	Token: string;
	EmailAddress: string;
	EffectivePremiumStatus: boolean;
	ActualPremiumStatus: boolean;
	SubscriptionToken: number;
	Expires: number;
	RenewAfter: number;
	IsTemporaryAccount: boolean;
	IsMerged: boolean;
	Bans: Curse_Friends_Enums.UserBanType;
}
export interface LoginRequest {
	Username: string;
	Password: string;
}
export interface RenewTokenResponseContract {
	Token: string;
	Expires: number;
	RenewAfter: number;
}
export interface LoginWithNetworkSessionRequest {
	SiteID: number;
	SessionID: string;
}
export interface TwitchOAuthResponse {
	Status: TwitchOAuthStatus;
	Session: LoginSession;
	Timestamp: number;
	MergeToken: string;
	TwitchUsername: string;
	TwitchDisplayName: string;
	TwitchAvatar: string;
	TwitchUserID: string;
}
export enum TwitchOAuthStatus {
	Success = 0,
	FailedValidation = 1,
	FailedInvalidOAuthCode = 2,
	FailedOAuthError = 3,
	RequiresMerge = 4,
}
export interface TwitchOAuthRequest {
	ClientID: string;
	Code: string;
	RedirectUri: string;
	State: string;
}
export interface TwitchMergeResponse {
	Status: TwitchMergeStatus;
	Session: LoginSession;
}
export enum TwitchMergeStatus {
	Success = 0,
	FailedValidation = 1,
	FailedInvalidOAuthCode = 2,
	FailedInvalidMergeToken = 3,
	FailedOAuthError = 4,
	FailedGeneralError = 5,
	FailedUnknownUser = 6,
	FailedInvalidPassword = 7,
	FailedCurseAccountMerged = 8,
	FailedTwitchAccountMerged = 9,
	FailedDeletedAccount = 10,
}
export interface TwitchMergeNewRequest {
	MergeToken: string;
}
export interface TwitchMergeExistingRequest {
	MergeToken: string;
	Username: string;
	Password: string;
}
export interface TwitchMergeTempAccountRequest {
	TempAccountToken: string;
	MergeToken: string;
}
export interface FuelAuthorizationResponseContract {
	AccessToken: string;
	RefreshToken: string;
	Expires: number;
	Scopes: string[];
	ErrorMessage: string;
	Status: string;
	Error: string;
}
export interface RegisterResponse {
	Status: RegisterStatus;
	StatusMessage: string;
	Session: LoginSession;
}
export enum RegisterStatus {
	Success = 0,
	EmailInUse = 1,
	UsernameInUse = 2,
	InvalidEmail = 3,
	InvalidProfile = 4,
	InvalidUsername = 5,
	InvalidPassword = 6,
	GeneralError = 7,
	TooManyAccountsSameIp = 8,
}
export interface RegisterRequest {
	Username: string;
	Password: string;
	Email: string;
	Newsletter: boolean;
}
export interface RegisterTempResponse {
	TempAccountToken: string;
	Status: RegisterStatus;
	StatusMessage: string;
	Session: LoginSession;
}
export interface RegisterTempRequest {
	Username: string;
}
export interface ClaimTempRequest {
	TempAccountToken: string;
	Email: string;
	Password: string;
}

