import * as Curse_SocketMessages from './Curse.SocketMessages';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';

export interface AttachmentNotification {
	ID: string;
	ConversationID: string;
	MessageID: string;
	Name: string;
	Title: string;
	Size: number;
	FileType: string;
	Url: string;
	Width: number;
	Height: number;
	IsAnimated: boolean;
	IsEmbed: boolean;
	AuthorID: number;
	AuthorName: string;
	Timestamp: number;
	RegionID: number;
}

export interface BlockedUserContract {
	UserID: number;
	Username: string;
	DisplayName: string;
}

export interface CallNotification {
	HostName: string;
	IpAddress: string;
	AccessToken: number;
	HostID: number;
	RegionName: string;
	InviteUrl: string;
	InviteCode: string;
	CallType: Curse_Friends_Enums.CallType;
	CallID: string;
	ConversationID: string;
	CreatorID: number;
	CreatorName: string;
	GameID?: number;
	AutoMatchKey?: number;
	Timestamp: Date;
	SenderID: number;
	SenderName: string;
	ForceJoin: boolean;
	Mode: Curse_Friends_Enums.CallMode;
}

export interface CallRespondedNotification {
	CallID: string;
	InviteCode: string;
	InviteUrl: string;
	Reason: Curse_Friends_Enums.CallResponseReason;
	UserID: number;
	Username: string;
	Timestamp: Date;
}

export interface ChannelContract {
	GroupTitle: string;
	GroupID: string;
	ParentGroupID: string;
	RootGroupID: string;
	VoiceSessionCode: string;
	MessageOfTheDay: string;
	GroupMode: Curse_Friends_Enums.GroupMode;
	GroupType: Curse_Friends_Enums.GroupType;
	GroupStatus: Curse_Friends_Enums.GroupStatus;
	DisplayOrder: number;
	DisplayCategoryID: string;
	DisplayCategory: string;
	DisplayCategoryRank: number;
	AllowTemporaryChildGroups: boolean;
	ForcePushToTalk: boolean;
	IsDefaultChannel: boolean;
	RolePermissions: { [key: number]: number };
	IsPublic: boolean;
	Membership: ChannelMembershipContract;
	UrlPath: string;
	VoiceMembers: GroupMemberContract[];
	HideNoAccess: boolean;
	HideCallMembersNoAccess: boolean;
	ExternalChannelID: string;
}

export interface ChannelMembershipContract {
	DateMessaged: Date;
	DateRead: Date;
	UnreadCount: number;
	IsFavorite: boolean;
	NotificationPreference: Curse_Friends_Enums.NotificationPreference;
	NotificationFilters: string[];
	NotificationMuteDate: Date;
}

export interface CharacterSearchContract {
	Score: any;
	SearchTerm: string;
	CharacterName: string;
	ServerName: string;
	ServerRegion: string;
	UniqueKey: string;
	UserID: number;
	GameID: number;
	FriendCount: number;
	Description: string;
	AvatarUrl: string;
	FriendshipAvailability: Curse_Friends_Enums.FriendshipRequestAvailability;
}

export interface ConversationMessageBadgeContract {
	BadgeSet: string;
	Version: string;
	Description: string;
	Title: string;
	ClickAction: string;
	ClickUrl: string;
}

export interface ConversationMessageEmoteSubstitutionNotification {
	MessageText: string;
	EmoteID: number;
	EmoteSet: number;
	StartIndex: number;
	EndIndex: number;
	EmoteHeight: number;
	EmoteWidth: number;
}

export interface ConversationMessageNotification {
	ClientID: string;
	ServerID: string;
	ConversationID: string;
	ContactID: string;
	ConversationType: Curse_Friends_Enums.ConversationType;
	RootConversationID: string;
	Timestamp: number;
	SenderID: number;
	SenderName: string;
	SenderUsername: string;
	SenderDisplayName: string;
	SenderPermissions: number;
	SenderRoles: number[];
	SenderVanityRole: number;
	Mentions: number[];
	RecipientID: number;
	Body: string;
	IsDeleted: boolean;
	DeletedTimestamp: number;
	DeletedUserID: number;
	DeletedUsername: string;
	EditedTimestamp: number;
	EditedUserID: number;
	EditedUsername: string;
	LikeCount: number;
	LikeUserIDs: number[];
	LikeUsernames: string[];
	ContentTags: number[];
	Attachments: AttachmentNotification[];
	NotificationType: Curse_Friends_Enums.ConversationNotificationType;
	EmoteSubstitutions: ConversationMessageEmoteSubstitutionNotification[];
	SpamConfidence: Curse_Friends_Enums.SpamConfidence;
	ExternalChannelID: string;
	ExternalUserID: string;
	ExternalUsername: string;
	ExternalUserDisplayName: string;
	ExternalUserColor: string;
	Badges: ConversationMessageBadgeContract[];
	BitsUsed: number;
}

export interface ConversationMessageRequest {
	ConversationID: string;
	AttachmentID: string;
	ClientID: string;
	Message: string;
	AttachmentRegionID: number;
}

export interface ConversationMessageResponse {
	ConversationID: string;
	Status: DeliveryStatus;
	ClientID: string;
	ServerID: string;
	RetryAfter?: number;
	ForbiddenReason: Curse_Friends_Enums.MessageForbiddenReason;
	MissingPermission: Curse_Friends_Enums.GroupPermissions;
}

export interface ConversationReadNotification {
	GroupID: string;
	FriendID: number;
	Timestamp: Date;
	ConversationID: string;
	MarkAllAsRead: boolean;
}

export enum DeliveryStatus {
	UnknownUser = 0,
	Error = 1,
	Forbidden = 2,
	FriendOffline = 3,
	Successful = 4,
	Throttled = 5,
}

export interface EmailSearchContract {
	Score: any;
	EmailAddress: string;
	UserID: number;
	FriendCount: number;
	AvatarUrl: string;
	FriendshipAvailability: Curse_Friends_Enums.FriendshipRequestAvailability;
	IsMerged: boolean;
}

export interface ExternalAccountChangedNotification {
	ChangeType: Curse_Friends_Enums.ExternalAccountChangeType;
	Account: ExternalAccountContract;
}

export interface ExternalAccountContract {
	ExternalID: string;
	ExternalName: string;
	ExternalDisplayName: string;
	Type: Curse_Friends_Enums.AccountType;
	IsPartnered: boolean;
	DateLinked: number;
	EligibleForVanityUrl: boolean;
	NeedsReauthentication: boolean;
}

export interface ExternalAccountPublicContract {
	ExternalID: string;
	ExternalName: string;
	ExternalDisplayName: string;
	Type: Curse_Friends_Enums.AccountType;
}

export interface ExternalCommunityContract {
	ExternalID: string;
	Type: Curse_Friends_Enums.AccountType;
	ExternalName: string;
	ExternalDisplayName: string;
	CreatedTimestamp: number;
	IsPartnered: boolean;
	Followers: number;
	Subscribers: number;
	GameID: number;
	ExternalGameName: string;
	ExternalStatus: string;
	ExternalUrl: string;
}

export interface ExternalCommunityEmoticonContract {
	CommunityType: Curse_Friends_Enums.AccountType;
	SyncID: string;
	Regex: string;
	RequiredRoles: Curse_Friends_Enums.GroupRoleTag[];
}

export interface ExternalCommunityLinkChangedNotification {
	ChangeType: Curse_Friends_Enums.ExternalCommunityLinkChangeType;
	Group: GroupNotification;
	Community: ExternalCommunityPublicContract;
}

export interface ExternalCommunityLinkContract {
	Community: ExternalCommunityContract;
	GroupID: string;
	SyncEmotes: boolean;
	SyncEvents: boolean;
	GracePeriodAction: Curse_Friends_Enums.SyncedMemberGracePeriodAction;
	GracePeriodDays: number;
	SyncedPremiumMembers: number;
	IsLive: boolean;
}

export interface ExternalCommunityMemberContract {
	ExternalUserID: string;
	ExternalUsername: string;
	ExternalUserDisplayName: string;
	ExternalCommunityID: string;
	ExternalCommunityName: string;
	ExternalCommunityType: Curse_Friends_Enums.AccountType;
	ExternalCommunityRole: Curse_Friends_Enums.GroupRoleTag;
	ExternalRoleIsActive: boolean;
	ExternalRoleFirstTimestamp: number;
	ExternalRoleCurrentTimestamp: number;
	ExternalRoleEntryNumber: number;
	GroupID: string;
	UserID: number;
	Username: string;
	GroupRoles: number[];
	GroupMember: GroupMemberContract;
}

export interface ExternalCommunityPublicContract {
	ExternalID: string;
	Type: Curse_Friends_Enums.AccountType;
	ExternalName: string;
	ExternalDisplayName: string;
	GameID: number;
	ExternalGameName: string;
	ExternalStatus: string;
	ExternalUrl: string;
	IsLive: boolean;
}

export interface ExternalCommunitySearchModelContract {
	Type: Curse_Friends_Enums.AccountType;
	ExternalID: string;
	ExternalName: string;
	ExternalDisplayName: string;
	AvatarUrl: string;
	ExternalStatus: string;
	ExternalGameName: string;
	IsLive: boolean;
	LiveTimestamp: number;
	ExternalUrl: string;
	Followers: number;
	SortRank: number;
}

export interface ExternalGuildContract {
	Type: Curse_Friends_Enums.AccountType;
	GameRegion: number;
	GameServer: string;
	Name: string;
	Faction: number;
	Level: number;
	MemberCount: number;
	GuildMasterGameServer: string;
	GuildMasterName: string;
	AchievementPoints: number;
	Emblem: any;
}

export interface FriendHintContract {
	ID: number;
	UserID: number;
	SearchTerm: string;
	Type: Curse_Friends_Enums.FriendHintType;
	GameID: number;
	Region: string;
	Server: string;
	Site: string;
	Platform: Curse_Friends_Enums.FriendPlatform;
	DisplayName: string;
	AvatarUrl: string;
	Description: string;
	Verification: Curse_Friends_Enums.FriendHintVerification;
	Status: Curse_Friends_Enums.FriendHintStatus;
	Visibility: Curse_Friends_Enums.FriendHintVisibility;
}

export interface FriendshipChangeNotification {
	Friendship: FriendshipContract;
}

export interface FriendshipContract {
	Status: Curse_Friends_Enums.FriendshipStatus;
	OtherUserID: number;
	OtherUsername: string;
	OtherDisplayName: string;
	OtherUserNickname: string;
	OtherUserRegionID: number;
	OtherUserConnectionStatus: Curse_Friends_Enums.UserConnectionStatus;
	InvitationMessage: string;
	IsFavorite: boolean;
	OtherUserStatusMessage: string;
	OtherUserGameID: number;
	OtherUserGameStatusMessage: string;
	OtherUserGameState: number;
	OtherUserGameTimestamp: Date;
	OtherUserAvatarUrl: string;
	DateConfirmed: Date;
	DateMessaged: Date;
	DateRead: Date;
	UnreadCount: number;
	MutualFriendCount: number;
	OtherUserConnectionStatusTimestamp: number;
	RequestedTimestamp: number;
	AvatarTimestamp: number;
	Capabilities: Curse_Friends_Enums.ClientCapability;
	OtherWatchingChannelID: string;
	OtherWatchingChannelName: string;
	OtherWatchingChannelUrl: string;
	OtherBroadcastingGameID: number;
	OtherIsBroadcasting: boolean;
}

export interface FriendshipRemovedNotification {
	FriendID: number;
}

export interface FriendSuggestionContract {
	FriendID: number;
	Username: string;
	AvatarUrl: string;
	FriendCount: number;
	Type: Curse_Friends_Enums.FriendSuggestionType;
	GameID: number;
	Platform: Curse_Friends_Enums.FriendPlatform;
	SuggestedTimestamp: number;
	FriendIDs: number[];
}

export interface FriendSuggestionNotification {
	Suggestions: FriendSuggestionContract[];
}

export interface GroupBulkMessageDeleteNotification {
	GroupID: string;
	UserID: number;
	StartMessageTimestamp: number;
	EndMessageTimestamp: number;
	DeletingUserID: number;
	DeletingUserName: string;
}

export interface GroupCallMemberListContract {
	GroupID: string;
	CallMembers: GroupMemberContract;
}

export interface GroupChangeNotification {
	ChangeType: Curse_Friends_Enums.GroupChangeType;
	SenderID: number;
	SenderName: string;
	Group: GroupNotification;
	Members: GroupMemberContract[];
	TimeStamp: Date;
	ChildGroups: ChannelContract[];
	RemovedReason: Curse_Friends_Enums.GroupMemberRemovedReason;
	MessageToUsers: string;
}

export interface GroupEmoticonNotification {
	GroupID: string;
	RegexString: string;
	SyncID: string;
	Url: string;
	RequiredRoles: number[];
}

export interface GroupEventChannelContract {
	ChannelID: string;
	Title: string;
	MessageOfTheDay: string;
	Type: Curse_Friends_Enums.GroupType;
	IsPublic: boolean;
	AccessRoles: number[];
	RoleID: number;
	RoleName: string;
	PermissionsStates: { [key: number]: number };
	Mode: Curse_Friends_Enums.GroupMode;
}

export interface GroupEventContract {
	RootGroupID: string;
	Category: Curse_Friends_Enums.GroupEventCategory;
	Type: Curse_Friends_Enums.GroupEventType;
	Timestamp: number;
	InitiatingUserID: number;
	InitiatingUsername: string;
	RootChangeFlags: Curse_Friends_Enums.GroupEventRootChangeFlags;
	PreviousRootGroupDetails: GroupEventGroupContract;
	RootGroupDetails: GroupEventGroupContract;
	ChannelChangeFlags: Curse_Friends_Enums.GroupEventChannelChangeFlags;
	PreviousChannelDetails: GroupEventChannelContract;
	ChannelDetails: GroupEventChannelContract;
	RoleChangeFlags: Curse_Friends_Enums.GroupEventRoleChangeFlags;
	PreviousRoleDetails: GroupEventRoleContract;
	RoleDetails: GroupEventRoleContract;
	LinkedCommunityChangeFlags: Curse_Friends_Enums.GroupEventCommunityChangeFlags;
	PreviousLinkedCommunityDetails: GroupEventLinkedCommunityContract;
	LinkedCommunityDetails: GroupEventLinkedCommunityContract;
	MemberDetails: GroupEventUserContract;
	GiveawayDetails: GroupEventGiveawayContract;
	PollDetails: GroupEventPollContract;
}

export interface GroupEventGiveawayContract {
	GiveawayID: number;
	Title: string;
	Entries: number;
	RollNumber: number;
	RollStatus?: Curse_Friends_Enums.GroupGiveawayRollStatus;
	WinnerUserID: number;
	WinnerUsername: string;
	WinnerBestRoleID: number;
	WinnerBestRoleName: string;
	WinnerValidStatus?: Curse_Friends_Enums.GroupGiveawayWinnerValidStatus;
}

export interface GroupEventGroupContract {
	Title: string;
	MessageOfTheDay: string;
	VoiceRegion: number;
	AfkTimerMinutes: number;
	IsPublic: boolean;
	ChatThrottleEnabled: boolean;
	ChatThrottleSeconds: number;
	IsSearchable: boolean;
	SearchTags: number[];
	SearchGames: number[];
	MatchAllGames: boolean;
	SearchDescription: string;
}

export interface GroupEventLinkedCommunityContract {
	ExternalID: string;
	ExternalName: string;
	SyncEmoticons: boolean;
	GracePeriodAction?: Curse_Friends_Enums.SyncedMemberGracePeriodAction;
	GracePeriodDays: number;
	IsStreaming: boolean;
}

export interface GroupEventPollContract {
	PollID: number;
	Title: string;
	TotalVotes: number;
	RequiredRoles: number[];
	OptionsCount: number;
	WinningOptions: string[];
	DurationMinutes: number;
}

export interface GroupEventRoleContract {
	RoleID: number;
	Name: string;
	Color: number;
	Badge: number;
	Rank: number;
	Permissions: Curse_Friends_Enums.GroupPermissions;
}

export interface GroupEventUserContract {
	UserID: number;
	Username: string;
	RoleID: number;
	RoleName: string;
	RemovedReason?: Curse_Friends_Enums.GroupMemberRemovedReason;
	RemovedMessage: string;
}

export interface GroupGiveawayChangedNotification {
	TimeStamp: number;
	ChangeType: Curse_Friends_Enums.GroupGiveawayChangeType;
	Giveaway: GroupGiveawayNotification;
	AffectedUser: GroupMemberContract;
	Requestor: GroupMemberContract;
	CurrentRoll: GroupGiveawayRollContract;
	Rolls: GroupGiveawayRollContract[];
}

export interface GroupGiveawayNotification {
	GroupID: string;
	GiveawayID: number;
	Title: string;
	CreatorID: number;
	RequiredRoles: number[];
	RoleBonuses: { [key: number]: number };
	ResponseWindowSeconds: number;
	SharingBonus: number;
	AllowRepeatWinners: boolean;
	AutoEnterActiveUsers: boolean;
	RollsBeforeWinner: number;
	AutoClaimRoles: number[];
	AutoEnterRoles: number[];
	IgnoredUsers: number[];
	Entries: number;
	FakeRollsLeft: number;
	TopShares: { [key: number]: number };
	Status: Curse_Friends_Enums.GroupGiveawayStatus;
	CurrentRollNumber: number;
	IncludeOfflineMembers: boolean;
}

export interface GroupGiveawayRollContract {
	UserID: number;
	Username: string;
	RollNumber: number;
	RollStatus: Curse_Friends_Enums.GroupGiveawayRollStatus;
	Timestamp: number;
	BestRoleID: number;
	BestRoleName: string;
	ValidStatus: Curse_Friends_Enums.GroupGiveawayWinnerValidStatus;
}

export interface GroupGiveawaySettingsNotification {
	GroupID: string;
	RequiredRoles: number[];
	RoleBonuses: { [key: number]: number };
	ResponseWindowSeconds: number;
	SharingBonus: number;
	IgnoredMembers: GroupMemberContract[];
	AutoEnterActiveUsers: boolean;
	AutoEnterRoles: number[];
	AutoClaimRoles: number[];
	RollsBeforeWinner: number;
	AllowRepeatWinners: boolean;
	IncludeOfflineMembers: boolean;
}

export interface GroupInvitationNotification {
	InviteCode: string;
	CreatorID: number;
	CreatorName: string;
	GroupID: string;
	Group: GroupNotification;
	ChannelID: string;
	Channel: GroupNotification;
	DateCreated: number;
	DateExpires?: number;
	MaxUses?: number;
	TimesUsed: number;
	IsRedeemable: boolean;
	InviteUrl: string;
	AdminDescription: string;
}

export interface GroupMemberContract {
	UserID: number;
	Username: string;
	DisplayName: string;
	Nickname: string;
	BestRole: number;
	Roles: number[];
	DateJoined: number;
	ConnectionStatus: Curse_Friends_Enums.UserConnectionStatus;
	DateLastSeen: number;
	DateLastActive: number;
	DateRemoved: number;
	IsActive: boolean;
	CurrentGameID: number;
	IsVoiceMuted: boolean;
	IsVoiceDeafened: boolean;
	AvatarTimestamp: number;
	ExternalAccounts: ExternalAccountPublicContract[];
	IsVerified: boolean;
	IsBanned: boolean;
}

export interface GroupMembershipNotification {
	Nickname: string;
	CanChangeNickname: boolean;
	BestRole: number;
	Roles: number[];
	DateJoined: Date;
	DateMessaged: Date;
	DateRead: Date;
	DateRemoved: Date;
	UnreadCount: number;
	IsFavorite: boolean;
	NotificationPreference: Curse_Friends_Enums.NotificationPreference;
	NotificationFilters: string[];
	NotificationMuteDate: Date;
	IsVoiceMuted: boolean;
	IsVoiceDeafened: boolean;
	IsBanned: boolean;
}

export interface GroupNotification {
	GroupTitle: string;
	GroupID: string;
	HomeRegionID: number;
	HomeRegionKey: string;
	ParentGroupID: string;
	RootGroupID: string;
	VoiceSessionCode: string;
	MessageOfTheDay: string;
	GroupType: Curse_Friends_Enums.GroupType;
	GroupSubtype: Curse_Friends_Enums.GroupSubType;
	DisplayOrder: number;
	MetaDataOnly: boolean;
	AllowTemporaryChildGroups: boolean;
	ForcePushToTalk: boolean;
	Status: Curse_Friends_Enums.GroupStatus;
	IsDefaultChannel: boolean;
	Roles: GroupRoleNotification[];
	RolePermissions: { [key: number]: number };
	Membership: GroupMembershipNotification;
	MemberCount: number;
	Emotes: GroupEmoticonNotification[];
	Members: GroupMemberContract[];
	Channels: ChannelContract[];
	GroupMode: Curse_Friends_Enums.GroupMode;
	IsPublic: boolean;
	UrlPath: string;
	UrlHost: string;
	ChatThrottleEnabled: boolean;
	ChatThrottleSeconds: number;
	IsStreaming: boolean;
	LinkedCommunities: ExternalCommunityPublicContract[];
	AfkTimerMins: number;
	AvatarTimestamp: number;
	FlaggedAsInappropriate: boolean;
	MembersOnline: number;
	HideNoAccess: boolean;
	HideCallMembersNoAccess: boolean;
	LinkedGuilds: ExternalGuildContract[];
	ExternalChannelID: string;
}

export interface GroupPollChangedNotification {
	ChangeType: Curse_Friends_Enums.GroupPollChangeType;
	Poll: GroupPollNotification;
	RequestorUserID: number;
}

export interface GroupPollNotification {
	GroupID: string;
	PollID: number;
	Title: string;
	Options: { [key: number]: string };
	Votes: { [key: number]: number };
	StartDate: number;
	RequiredRoles: number[];
	AllowMultipleSelections: boolean;
	DisplayType: Curse_Friends_Enums.GroupPollDisplayType;
	Status: Curse_Friends_Enums.GroupPollStatus;
	PublicCode: string;
	PublicUrl: string;
	AllowRevotes: boolean;
	DuplicationMode: Curse_Friends_Enums.GroupPollDuplicateMode;
	MillisecondsLeft?: number;
}

export interface GroupPollSettingsNotification {
	GroupID: string;
	AllowMultipleSelections: boolean;
	DisplayType: Curse_Friends_Enums.GroupPollDisplayType;
	RequiredRoles: number[];
	IsPublic: boolean;
	AllowRevotes: boolean;
	DuplicateMode: Curse_Friends_Enums.GroupPollDuplicateMode;
}

export interface GroupPreferenceNotification {
	GroupID: string;
	Preference: Curse_Friends_Enums.NotificationPreference;
	IsFavorite: boolean;
	Timestamp: Date;
}

export interface GroupPresenceContract {
	UserID: number;
	ConnectionStatus: Curse_Friends_Enums.UserConnectionStatus;
	GameID: number;
	DateLastSeen: number;
	IsActive: boolean;
}

export interface GroupPresenceNotification {
	GroupID: string;
	Users: GroupPresenceContract[];
}

export interface GroupPrivateConversationContract {
	UserID: number;
	OtherUserID: number;
	OtherUsername: string;
	OtherUserDisplayName: string;
	DateCreated: Date;
	DateMessaged: Date;
	DateRead: Date;
	UnreadCount: number;
	IsBlockedByThem: boolean;
	IsBlockedByMe: boolean;
}

export interface GroupRoleNotification {
	RoleID: number;
	Name: string;
	Rank: number;
	VanityColor: number;
	VanityBadge: number;
	HasCustomVanityBadge: boolean;
	IsDefault: boolean;
	IsOwner: boolean;
	Tag: Curse_Friends_Enums.GroupRoleTag;
	Source: Curse_Friends_Enums.AccountType;
	IsHidden: boolean;
	ExternalID: string;
}

export interface GroupSearchModelContract {
	GroupID: string;
	GroupTitle: string;
	OwnerUserID: number;
	OwnerUsername: string;
	Tags: Curse_Friends_Enums.GroupSearchTag[];
	IsPublic: boolean;
	Description: string;
	MemberCount: number;
	Games: number[];
	MatchAllGames: boolean;
	IsStreaming: boolean;
	StreamingTimestamp: number;
	Subtype: Curse_Friends_Enums.GroupSubType;
	IsFeatured: boolean;
	FeaturedTimestamp: number;
	FlaggedAsInappropriate: boolean;
	CreationTimestamp: number;
	SortRank: number;
}

export interface GroupSuggestionsNotification {
	TwitchSuggestions: TwitchGroupSuggestionNotification[];
}

export interface HealthCheckRequest {
	ApiKey: string;
	MachineName: string;
}

export interface JoinRequest {
	UserID: number;
	MachineKey: string;
	SessionID: string;
	Status: Curse_Friends_Enums.UserConnectionStatus;
	ClientVersion: string;
	PublicKey: any;
	CipherAlgorithm: any;
	CipherStrength: number;
}

export interface JoinResponse {
	Status: JoinStatus;
	ServerTime: Date;
	EncryptedSessionKey: any;
	ConnectionStatus: Curse_Friends_Enums.UserConnectionStatus;
}

export enum JoinStatus {
	Successful = 1,
	FailedUnhandledException = 2,
	InvalidClientVersion = 3,
	InvalidSessionID = 4,
	Timeout = 5,
	Throttled = 6,
}

export interface MutualFriendNotification {
	UserID: number;
	MutualUserIDs: number[];
}

export interface PlatformSearchContract {
	Score: any;
	SearchTerm: string;
	Identity: string;
	UniqueKey: string;
	UserID: number;
	Platform: Curse_Friends_Enums.FriendPlatform;
	Visibility: Curse_Friends_Enums.FriendHintVisibility;
	FriendCount: number;
	Description: string;
	AvatarUrl: string;
	FriendshipAvailability: Curse_Friends_Enums.FriendshipRequestAvailability;
}

export interface PrivateConversationContract {
	OtherUserID: number;
	ConversationID: string;
	Title: string;
	DateMessaged: Date;
	DateRead: Date;
	UnreadCount: number;
}

export interface TemporaryAccessTokenContract {
	AccessToken: string;
	DateExpires: number;
}

export interface TwitchChatNoticeNotification {
	ExternalChannelID: string;
	NoticeType: Curse_Friends_Enums.TwitchChatNoticeType;
	NoticeText: string;
	DurationSeconds: number;
	Timestamp: number;
	ExternalUserID: string;
	ExternalUsername: string;
}

export interface TwitchGroupSuggestionNotification {
	GroupID: string;
	StreamID: string;
	TwitchName: string;
	Role: Curse_Friends_Enums.GroupRoleTag;
}

export interface UserBanStatusNotification {
	UserID: number;
	Bans: Curse_Friends_Enums.UserBanType;
}

export interface UserChangeNotification {
	User: UserContract;
}

export interface UserClientSettingsNotification {
	UserID: number;
	DateUpdated: number;
	GlobalSettings: string;
	DesktopSettings: string;
	WebSettings: string;
	MobileSettings: string;
}

export interface UserContract {
	UserID: number;
	Username: string;
	ConnectionStatus: Curse_Friends_Enums.UserConnectionStatus;
	CustomStatusMessage: string;
	CustomStatusTimestamp: Date;
	FriendCount: number;
	CurrentGameID: number;
	CurrentGameState: number;
	CurrentGameStatusMessage: string;
	CurrentGameTimestamp: Date;
	GroupMessagePushPreference: Curse_Friends_Enums.PushNotificationPreference;
	FriendMessagePushPreference: Curse_Friends_Enums.PushNotificationPreference;
	FriendRequestPushEnabled: boolean;
	MentionsPushEnabled?: boolean;
	AvatarTimestamp: number;
	DisplayName: string;
	WatchingChannel: ExternalCommunityPublicContract;
	IsBroadcasting: boolean;
	BroadcastingGameID: number;
	PrivacySettings: UserPrivacySettingsContract;
	ConfirmedFriendSyncCount: number;
	DeclinedFriendSyncCount: number;
}

export interface UsernameSearchContract {
	Score: any;
	Username: string;
	DisplayName: string;
	UserID: number;
	FriendCount: number;
	AvatarUrl: string;
	FriendshipAvailability: Curse_Friends_Enums.FriendshipRequestAvailability;
	IsMerged: boolean;
}

export interface UserPrivacySettingsContract {
	PrivateMessagePrivacy: Curse_Friends_Enums.PrivateMessagePrivacy;
	FriendRequestPrivacy: Curse_Friends_Enums.FriendRequestPrivacy;
	ShareActivityPrivacy: Curse_Friends_Enums.ShareActivityPrivacy;
}

export interface UserProfileNotification {
	UserID: number;
	Username: string;
	DisplayName: string;
	Name: string;
	City: string;
	State: string;
	CountryCode: string;
	AboutMe: string;
	FriendCount: number;
	LastGameID: number;
	Identities: FriendHintContract[];
	MutualFriends: MutualFriendNotification[];
	MutualGroupIDs: string[];
}


