import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
export interface ActivePollContract {
	Poll: Curse_Friends_NotificationContracts.GroupPollNotification;
	MyVotes: number[];
}
export interface CreatePollRequest {
	Title: string;
	Options: { [key: number]: string };
	DisplayType: Curse_Friends_Enums.GroupPollDisplayType;
	RequiredRoles: number[];
	DurationMinutes: number;
	AllowMultiSelect: boolean;
	IsPublic: boolean;
	AllowRevotes: boolean;
	DuplicateMode: Curse_Friends_Enums.GroupPollDuplicateMode;
}
export interface GroupPollResult {
	GroupID: string;
	PollID: number;
	Title: string;
	RequiredRoles: number[];
	DurationMinutes: number;
	DateEnded: number;
	TotalVotes: number;
	TotalOptions: number;
	WinningOptions: string[];
}
export interface SearchPollHistoryRequest {
	PageSize?: number;
	PageNumber?: number;
}
export interface PublicActivePollContract {
	Group: Curse_Friends_NotificationContracts.GroupNotification;
	Poll: Curse_Friends_NotificationContracts.GroupPollNotification;
	MyVotes: number[];
}

