import * as Curse_Friends_NotificationContracts from './Curse.Friends.NotificationContracts';
import * as Curse_Friends_Enums from './Curse.Friends.Enums';
export interface ChangeCommunitySettingsRequest {
	SyncEmoticons: boolean;
	SyncEvents: boolean;
	GracePeriodAction: Curse_Friends_Enums.SyncedMemberGracePeriodAction;
	GracePeriodDays: number;
}
export interface SyncedCommunityMembershipResponse {
	TwitchSuggestions: SyncedServerMembership[];
	YouTubeSuggestions: SyncedServerMembership[];
}
export interface SyncedServerMembership {
	GroupID: string;
	GroupTitle: string;
	GroupMemberCount: number;
	IsPublic: boolean;
	ExternalCommunityID: string;
	ExternalCommunityName: string;
	ExternalCommunityType: Curse_Friends_Enums.AccountType;
	RoleTag: Curse_Friends_Enums.GroupRoleTag;
	IsMember: boolean;
}
export interface PremiumMemberSearchResponse {
	Active: number;
	Inactive: number;
	Results: Curse_Friends_NotificationContracts.ExternalCommunityMemberContract[];
}
export interface FollowTwitchChannelResponse {
	SuccessfulAccounts: string[];
	UnsuccessfulAccounts: string[];
}
export interface LinkExternalAccountRequest {
	SuccessRedirectUrl: string;
	FailureRedirectUrl: string;
	ForceVerify?: boolean;
	GameRegion?: number;
}
export interface AccountResyncResponse {
	Status: AccountResyncStatus;
	RetryAfterMilliseconds: number;
}
export enum AccountResyncStatus {
	Error = 0,
	Success = 1,
	Throttled = 2,
}
export interface LinkGuildRequest {
	Roles: SyncedGuildRoleName[];
}
export interface SyncedGuildRoleName {
	Tag: Curse_Friends_Enums.GroupRoleTag;
	Name: string;
}
export interface GuildDetailsContract {
	GuildInfo: Curse_Friends_NotificationContracts.ExternalGuildContract;
	Ranks: GuildRankDetailsContract[];
}
export interface GuildRankDetailsContract {
	Rank: Curse_Friends_Enums.GroupRoleTag;
	MyMembers: GuildMemberDetailsContract[];
	SampleMembers: GuildMemberDetailsContract[];
}
export interface GuildMemberDetailsContract {
	GameServer: string;
	Name: string;
}

