
export interface AddPendingUsersNotification {
	Users: PendingUser[];
}

export interface ChatMessageNotification {
	SenderID: number;
	Body: string;
	Timestamp: Date;
}

export interface ChatMessageRequest {
	Body: string;
	ClientID: string;
}

export interface ChatMessageResponse {
	Status: ChatMessageStatus;
	Timestamp: Date;
	ClientID: string;
}

export enum ChatMessageStatus {
	Successful = 1,
	FloodControl = 2,
	MessageTooLarge = 3,
	Error = 4,
}

export interface CodecInfo {
	Name: string;
	PacketMilliseconds: number;
	SampleRate: number;
	VideoWidth: number;
	VideoHeight: number;
}

export interface FailoverNotification {
	HostName: string;
	IPAddress: string;
	Port: number;
	AccessToken?: number;
	Reason: FailoverNotificationReason;
}

export enum FailoverNotificationReason {
	HostUpdating = 0,
	ChangingMode = 1,
}

export interface GetUsersRequest {
	Signal: boolean;
}

export interface GetUsersResponse {
	Users: VoiceSessionMember[];
	SessionType: VoiceInstanceType;
	PendingUsers: PendingUser[];
	Timestamp: Date;
}

export interface JoinSessionRequest {
	SessionID: string;
	AvatarUrl: string;
	UserID?: number;
	DisplayName: string;
	SmallAvatarUrl: string;
	InGameName: string;
	InGameRegion: string;
	ClientVersion: string;
	AuthToken: string;
	AccessToken?: number;
	CodecInfo: CodecInfo;
	WebRTCType: MultiStreamType;
	SupportsVideo: boolean;
	VideoCodec: CodecInfo;
}

export interface JoinSessionResponse {
	ClientID: number;
	Users: VoiceSessionMember[];
	Status: JoinSessionStatus;
	CurrentUserID: number;
	Type: VoiceInstanceType;
	PendingUsers: PendingUser[];
	Timestamp: Date;
}

export enum JoinSessionStatus {
	Successful = 1,
	FailedNameAlreadyTaken = 2,
	FailedUnhandledException = 3,
	InvalidClientVersion = 4,
	SessionNotFound = 5,
	FailedSessionFull = 6,
	Timeout = 7,
	Throttled = 8,
	Forbidden = 9,
}

export interface LeaveSessionRequest {
	Signal: boolean;
}

export interface ModDeafenUserRequest {
	UserID: number;
	Deafen: boolean;
}

export interface ModDeafenUserResponse {
	Success: boolean;
}

export interface ModKickUserRequest {
	UserID: number;
}

export interface ModKickUserResponse {
	Success: boolean;
}

export interface ModMuteUserRequest {
	UserID: number;
	Mute: boolean;
}

export interface ModMuteUserResponse {
	Success: boolean;
}

export enum MultiStreamType {
	None = 0,
	PlanA = 1,
	PlanB = 2,
	Unified = 3,
	NullCipher = 4,
}

export interface PendingUser {
	UserID: number;
	DisplayName: string;
	AvatarUrl: string;
}

export interface ReJoinSessionRequest {
	Signal: boolean;
}

export interface RemovePendingUserNotification {
	UserID: number;
	Reason: RemovePendingUserReason;
}

export enum RemovePendingUserReason {
	Declined = 0,
	NoAnswer = 1,
	Kicked = 2,
	LeftGroup = 3,
}

export interface SessionDescriptionAnswer {
	Description: string;
}

export interface SessionDescriptionOffer {
	Description: string;
}

export interface TransmitEndNotification {
	ClientID: number;
}

export interface TransmitEndRequest {
	Signal: boolean;
}

export interface TransmitStartNotification {
	ClientID: number;
}

export interface TransmitStartRequest {
	Signal: boolean;
}

export interface UpdateUserRequest {
	DisplayName: string;
	AvatarUrl: string;
	SmallAvatarUrl: string;
	InGameName: string;
	InGameRegion: string;
	SupportsVideo?: boolean;
	VideoCodec: CodecInfo;
}

export interface UserDisconnectNotification {
	AffectedUserID: number;
	InitiatingUserID: number;
	Reason: UserDisconnectReason;
	Timestamp: Date;
}

export enum UserDisconnectReason {
	Kicked = 0,
	Duplicate = 1,
	CallEnded = 2,
	NoAnswer = 3,
	LeftGroup = 4,
}

export interface UserJoinedNotification {
	User: VoiceSessionMember;
	Timestamp: Date;
}

export interface UserLeftNotification {
	UserID: number;
	Timestamp: Date;
}

export interface UserUpdatedNotification {
	ID: number;
	DisplayName: string;
	AvatarUrl: string;
	InGameRegion: string;
	InGameName: string;
	IsModMuted: boolean;
	IsModDeafened: boolean;
	VideoCodec: CodecInfo;
}

export interface VoiceInstanceChangedNotification {
	NewType: VoiceInstanceType;
}

export enum VoiceInstanceMode {
	Audio = 1,
	Video = 2,
}

export enum VoiceInstanceType {
	AdHoc = 1,
	AutoMatch = 2,
	Friend = 3,
	Group = 4,
	MultiFriend = 5,
}

export interface VoiceSessionMember {
	ClientID: number;
	UserID?: number;
	DisplayName: string;
	AvatarUrl: string;
	SmallAvatarUrl: string;
	InGameName: string;
	InGameRegion: string;
	CodecInfo: CodecInfo;
	IsModMuted: boolean;
	IsModDeafened: boolean;
	CanSpeak: boolean;
	VideoCodec: CodecInfo;
}


