﻿param(
    [Parameter(Mandatory=$true)]
    [string]$method,

    [switch]$RunAsSelf
)

$domain='CURSED'
$username = 'teamcity'

function Prompt-Credentials
{
    param
    (
        [string]$domain=$Script:domain,
        [string]$username=$Script:username
    )

    $creds = Get-Credential -UserName "$domain\$username" -Message "Enter Git password"

    if(!$creds)
    {
        exit 401
    }

    $creds
}

if($method.ToLower() -eq "add")
{
    $creds = Prompt-Credentials

    $args = "/c cmdkey /generic:git:https://github.curse.us /user:$username /pass:$($creds.GetNetworkCredential().Password) & pause"

    if($RunAsSelf)
    {
        $process = start-process "cmd" -ArgumentList $args -PassThru -WorkingDirectory "C:\"
    }
    else
    {
        $process = start-process "cmd" -Credential $creds -ArgumentList $args -PassThru -WorkingDirectory "C:\"
    }
}
elseif($method.ToLower() -eq "delete")
{
    $args = "/c cmdkey /delete:git:https://github.curse.us & pause"

    if($RunAsSelf)
    {
        $process = start-process "cmd" -ArgumentList $args -PassThru -WorkingDirectory "C:\"
    }
    else
    {
        $creds = Prompt-Credentials
        $process = start-process "cmd" -Credential $creds -ArgumentList "$args" -PassThru -WorkingDirectory "C:\"
    }
}
else
{
    Write-Error "Unknown method $method"
    Exit 403
}

$process.WaitForExit()

