﻿$ScriptPath = Split-Path $MyInvocation.MyCommand.Path
$config = ([xml](Get-Content "$ScriptPath\KillLoadTest.config")).FirstChild

foreach($client in $config.Hosts.ChildNodes | where {$_.NodeType -ne 'Comment'} | select -Property InnerText | foreach {$_.InnerText})
{
    Write-Output "Stopping Load Test Client + Host on $client"

    foreach($proc in Get-WmiObject Win32_Process -ComputerName $client | where { $_.ProcessName -match 'Curse.LoadTests.Client.exe'})
    {
        $proc.Terminate()

        if($LASTEXITCODE)
        {
            Write-Output "Terminate terminated with error code $LASTEXITCODE"
        }
    }
}