﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ServiceProcess;
using Curse.Logging;

namespace Curse.LoadTest.Service
{
    public class LoadTestService : ServiceBase
    {
        public LoadTestService()
        {
            ServiceName = "CurseGroupService";
        }

        public void OnDebugStart()
        {
            OnStart(null);

        }

        public void OnDebugStop()
        {
            OnStop();
        }

        protected override void OnStart(string[] args)
        {
            var sw = Stopwatch.StartNew();
            EventLog.WriteEntry("Load Test Starting", EventLogEntryType.Information);

            Logger.Init(new LoggerConfig(@"C:\Curse\Logs") { LogRetainCount = 100, MaxLogSize = Int32.MaxValue });
            
            Logger.Info("Load Test Starting");

            // Add the event handler for handling non-UI thread exceptions to the event. 
            AppDomain.CurrentDomain.UnhandledException += CurrentDomain_UnhandledException;
            ReallyStartService(sw);
        }

        void ReallyStartService(object o)
        {
            var sw = o as Stopwatch;
            try
            {
                EventLog.WriteEntry("Initializing Configuration", EventLogEntryType.Information);
                StorageConfiguration.Initialize("GroupService");
                EventLog.WriteEntry("Group Server Starting", EventLogEntryType.Information);
                GroupServer.Start();
                FriendsStatsManager.Initialize(FriendsHostType.GroupService);
            }
            catch (Exception ex)
            {
                EventLog.WriteEntry("Failed to start: " + ex.Message, EventLogEntryType.Error);
                Logger.Error(ex, "Notification has failed to start, due to an unhandled exception.");
                throw;
            }

            EventLog.WriteEntry("Group Service Started", EventLogEntryType.Information);

            sw.Stop();
            Logger.Info("Group Service Started in " + sw.Elapsed.TotalSeconds.ToString("###,##0.00") + " seconds");

        }

        void CurrentDomain_UnhandledException(object sender, UnhandledExceptionEventArgs e)
        {
            var exception = e.ExceptionObject as Exception;
            Logger.Error(exception, "Service has crashed!");
        }

        protected override void OnStop()
        {
            try
            {
                base.RequestAdditionalTime(30 * 1000);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to request additional time.");
            }

            try
            {
                GroupServer.Stop();
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to cleanly stop service.");
            }

        }
    }
}
