﻿using System;
using System.Collections.Concurrent;

namespace Curse.LoadTests.Client.Behavior
{
    class ClientAction
    {
        private readonly Action<ClientBehavior> _action;
        private readonly TimeSpan? _minimumInterval;
        private readonly ConcurrentDictionary<int, DateTime> _lastExecutedDictionary = new ConcurrentDictionary<int, DateTime>();
        private readonly Func<ClientBehavior, bool> _additionalCanPerform; 

        public int Weight { get; private set; }

        public ClientAction(Action<ClientBehavior> action, int weight, TimeSpan? minimumInterval = null, Func<ClientBehavior, bool> additionalCanPerform = null)
        {
            _action = action;
            _minimumInterval = minimumInterval;
            _additionalCanPerform = additionalCanPerform;
            Weight = weight;
        }

        public bool CanPerform(ClientBehavior client)
        {
            DateTime lastExecuted;
            if (_minimumInterval == null || !_lastExecutedDictionary.TryGetValue(client.CurrentUser.UserID, out lastExecuted))
            {
                return true;
            }

            var canPerform = DateTime.UtcNow - lastExecuted >= _minimumInterval.Value;

            if (!canPerform)
            {
                return false;
            }

            return _additionalCanPerform == null || _additionalCanPerform(client);
        }

        public void Perform(ClientBehavior client)
        {
            if (!CanPerform(client))
            {
                throw new InvalidOperationException();
            }

            _lastExecutedDictionary.AddOrUpdate(client.CurrentUser.UserID, id => DateTime.UtcNow, (id, old) => DateTime.UtcNow);
            _action(client);
        }
    }
}
