﻿using System;
using System.IO;
using System.Xml.Serialization;
using Curse.Logging;

namespace Curse.LoadTests.Client.Configuration
{
    public enum ConfigurationMode
    {
        Debug,
        ConsoleApp,
        WindowsService
    }

    [XmlType("Client")]
    public class ClientConfiguration
    {
        public static ConfigurationMode Mode { get; private set; }

        private static readonly ClientConfiguration _instance = null;

        public static ClientConfiguration Instance
        {
            get { return _instance; }
        }

        static ClientConfiguration()
        {
            
#if CONFIG_CONSOLEAPP
            Mode = ConfigurationMode.ConsoleApp;
#elif CONFIG_WINDOWSSERVICE
            Mode = ConfigurationMode.WindowsService;
#elif DEBUG
            Mode = ConfigurationMode.Debug;
#endif
            // Try to load the config, based on the compilation mode

            Logger.Info("Current configuration is: " + Mode);
            
            var configPath = FindConfigPath();

            Logger.Info("Loading service configuration from: " + configPath);

            using (var reader = new StreamReader(configPath))
            {
                var dcs = new XmlSerializer(typeof(ClientConfiguration));
                _instance = (ClientConfiguration)dcs.Deserialize(reader);
            }

        }

        private static string FindConfigPath()
        {
            string configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configuration", "Client." + Mode.ToString() + ".config");

            if (!File.Exists(configPath))
            {
                configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "bin", "Configuration", "Client." + Mode.ToString() + ".config");
            }

            if (!File.Exists(configPath))
            {
                throw new Exception("Configuration could not be loaded from '" + configPath + "'");
            }

            return configPath;
        }

        public void Save()
        {
            var configPath = FindConfigPath();

            using (var writer = new StreamWriter(configPath))
            {
                var dcs = new XmlSerializer(typeof(ClientConfiguration));
                dcs.Serialize(writer, this);
            }
        }

        [XmlElement]
        public int StatisticsIntervalMinutes { get; set; }

        [XmlElement]
        public string MonitorServiceUrl { get; set; }

        [XmlElement]
        public string CentralLogServiceUrl { get; set; }

        [XmlElement]
        public string CentralServiceApiKey { get; set; }

        [XmlElement]
        public int LocalRegionID { get; set; }
    }
}
