﻿using Curse.Friends.Client.FriendsService;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.LoadTests.Client.Models
{
    class Friend : User
    {
        public Friend(Friendship friendship)
        {
            UserID = friendship.OtherUserID;
            Username = friendship.OtherUsername;

            UpdateFromFriendship(friendship);
        }

        public Friend(FriendshipContract friendship)
        {
            UserID = friendship.OtherUserID;
            Username = friendship.OtherUsername;

            UpdateFromNotification(friendship);
        }

        public Friend UpdateFromFriendship(Friendship friendship)
        {
            ConnectionStatus = friendship.OtherUserConnectionStatus;
            FriendshipStatus = friendship.Status;
            Nickname = friendship.OtherUserNickname;
            AvatarUrl = friendship.OtherUserAvatarUrl;
            GameID = friendship.OtherUserGameID;
            GameState = friendship.OtherUserGameState;
        
            return this;
        }

        public Friend UpdateFromNotification(FriendshipContract friendship)
        {
            ConnectionStatus = friendship.OtherUserConnectionStatus;
            FriendshipStatus = friendship.Status;
            Nickname = friendship.OtherUserNickname;
            AvatarUrl = friendship.OtherUserAvatarUrl;
            GameID = friendship.OtherUserGameID;
            GameState = friendship.OtherUserGameState;

            return this;
        }

        public FriendshipStatus FriendshipStatus { get; set; }

        public string Nickname { get; set; }

        public override bool IsOnline { get { return base.IsOnline && ConnectionStatus != UserConnectionStatus.Invisible; } }
    }
}
