﻿using System;

namespace Curse.LoadTests.Client.Models
{
    class PendingCall
    {
        public PendingCall(string inviteUrl, int friendID, long accessToken, DateTime? calledAt)
        {
            InviteUrl = inviteUrl;
            FriendID = friendID;
            AccessToken = accessToken;
            CalledAt = calledAt ?? DateTime.UtcNow;
        }

        public PendingCall(string inviteUrl, Guid groupID, DateTime? calledAt)
        {
            InviteUrl = inviteUrl;
            GroupID = groupID;
            CalledAt = calledAt ?? DateTime.UtcNow;
        }

        public string InviteUrl { get; private set; }

        public long? AccessToken { get; private set; }

        public int? FriendID { get; private set; }

        public Guid? GroupID { get; private set; }

        public DateTime CalledAt { get; private set; }

        public bool IsPending
        {
            get { return DateTime.UtcNow - CalledAt < TimeSpan.FromSeconds(5); }
        }
    }
}
