﻿using System;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Net;
using System.ServiceProcess;
using System.Threading;
using Curse.Friends.Configuration;
using Curse.Friends.Data;
using Curse.Friends.Data.Models;
using Curse.LoadTests.Client.Behavior;
using Curse.LoadTests.Client.Utilities;
using Curse.LoadTests.Enums;
using Curse.Logging;
using Curse.Logging.Uploader;
using Newtonsoft.Json;

namespace Curse.LoadTests.Client
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            ServicePointManager.ServerCertificateValidationCallback += (a, b, c, d) => true;

            Logger.Init(new LoggerConfig(@"C:\Curse\Logs\CurseLoadTestClient\") {MaxLogSize = 512*1024*1024, LogRetainCount = 2});
            LogUploader.Initialize(16, "http://voice-service.cursevoice.opt/CurseVoiceService.svc", "***REMOVED***");

            NotificationReceiver.Init();

#if CONFIG_CONSOLEAPP

            var mre = new ManualResetEventSlim(false);
            LoadTest.Instance.StatusChanged += (sender, eventArgs) =>
            {
                if (LoadTest.Instance.Status == ClientStatus.Ready || LoadTest.Instance.Status == ClientStatus.Offline)
                {
                    mre.Set();
                }
            };

            ClientServiceHost.Instance.Initialize();

            // TODO: Wait for behavior to stop
            mre.Wait();
            LogUploader.Shutdown();

#elif CONFIG_WINDOWSSERVICE

            ServiceBase.Run(new ServiceBase[] {new LoadTestClientService()});
#else
            StorageConfiguration.Initialize("LoadTestRedo", ConfigurationRegion.USEast.Key);
            LoadTestData.WipeTable<Group>();
            LoadTestData.WipeTable<GroupMemberList>();
            LoadTestData.WipeTable<GroupMembership>();
            LoadTestData.WipeTable<UserClientEndpointMap>();
            LoadTestData.WipeTable<Friendship>();

            var users = LoadTestUsers.GetUsers(0, 399);

            var userIDs = users.Select(u => u.UserID).ToArray();
            LoadTestData.ResetUserFriendCount(userIDs);
            LoadTestData.ResetUserStatus(userIDs);
            LoadTestData.ResetFriendStatus(userIDs);
            LoadTestData.ResetClientEndpoints(userIDs);

            LoadTest.Instance.Start(users, 1234);

            Console.WriteLine("Test started. Press enter to stop the behavior thread.");
            Console.ReadLine();
            ClientServiceHost.Instance.Stop();

            Console.WriteLine("Press enter to dump the actions into files and exit");
            Console.ReadLine();
            ClientServiceHost.Instance.Terminate();

            LoadTest.WriteResults();

            foreach (var client in LoadTest.Instance.Clients)
            {
                using (var stream = new StreamWriter(string.Format("results/{0}.txt", client.Key)))
                {
                    object @object;
                    while (client.Value.TryDequeueActionOrEvent(out @object))
                    {
                        stream.WriteLine("{0} - {1}", @object.GetType().Name, JsonConvert.SerializeObject(@object));
                    }
                }
            }

            StorageConfiguration.Shutdown();
            LogUploader.Shutdown();
#endif
        }
    }
}
