﻿using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;

namespace Curse.LoadTests.Client.ServiceClients
{
    [DataContract(Namespace = HeaderNamespace)]
    public sealed class AuthenticationToken
    {
        public const string HeaderName = "AuthenticationToken";
        public const string HeaderNamespace = "urn:Curse.FriendsService:v1";

        public AuthenticationToken(int userID, string token, string apiKey)
        {
            Token = token;
            UserID = userID;
            ApiKey = apiKey;
        }

        // These are the fields that will be serialized and passed through the header
        [DataMember]
        public int UserID { get; set; }

        // These are the fields that will be serialized and passed through the header
        [DataMember]
        public string Token { get; set; }

        public string Username { get; set; }

        public string Email { get; set; }

        [DataMember]
        public string ApiKey { get; set; }

        public bool IsAnonymous
        {
            get;
            set;
        }
    }

    public sealed class AuthTokenExtension : IEndpointBehavior, IClientMessageInspector
    {
        private readonly AuthenticationToken _token;

        public AuthTokenExtension(AuthenticationToken token)
        {
            _token = token;
        }

        object IClientMessageInspector.BeforeSendRequest(ref Message request, IClientChannel channel)
        {
            var messageHeader = MessageHeader.CreateHeader(AuthenticationToken.HeaderName,
                AuthenticationToken.HeaderNamespace, _token);
            request.Headers.Add(messageHeader);
            return null;

        }

        void IEndpointBehavior.ApplyClientBehavior(ServiceEndpoint endpoint, ClientRuntime clientRuntime)
        {
            clientRuntime.MessageInspectors.Add(new AuthTokenExtension(_token));
        }

        void IClientMessageInspector.AfterReceiveReply(ref Message reply, object correlationState)
        {
            // Do nothing
        }

        void IEndpointBehavior.AddBindingParameters(ServiceEndpoint endpoint, BindingParameterCollection bindingParameters)
        {
            // Do nothing
        }

        void IEndpointBehavior.ApplyDispatchBehavior(ServiceEndpoint endpoint, EndpointDispatcher endpointDispatcher)
        {
            // Do nothing
        }

        void IEndpointBehavior.Validate(ServiceEndpoint endpoint)
        {
            // Do nothing
        }
    }
}
