﻿using System;
using System.ServiceModel;
using System.ServiceModel.Channels;
using Curse.CloudServices.Client;
using Curse.Friends.Client.FriendsService;

namespace Curse.LoadTests.Client.ServiceClients
{
    class FriendsWebClient : BaseServiceClient<FriendsWebClient,IFriendsService,FriendsServiceClient>
    {
        private const string FriendsServiceAddress = "https://friends-service.cursevoice.opt/FriendsService.svc";
        private static readonly EndpointAddress Endpoint = new EndpointAddress(FriendsServiceAddress);
        private static readonly Binding Binding = BindingHelper.GetBinaryBinding(true);

        /// <summary>
        /// This is needed for the base class implementation and should not be called manually
        /// </summary>
        public FriendsWebClient()
        {
        }

        private readonly int _userID;
        private readonly string _apiKey;
        private string _token;

        public FriendsWebClient(int userID, string apiKey=null)
        {
            _userID = userID;
            _apiKey = apiKey;
        }

        public void UpdateToken(string token)
        {
            _token = token;
        }

        protected override FriendsServiceClient CreateClient()
        {
            if (_token == null)
            {
                throw new InvalidOperationException();
            }
            var client = new FriendsServiceClient(Binding, Endpoint);

            CurrentToken = _token;
            client.ChannelFactory.Endpoint.Behaviors.Add(new AuthTokenExtension(new AuthenticationToken(_userID, _token, _apiKey)));
            return client;
        }

        protected override bool RenewToken()
        {
            return _token != null && _token == CurrentToken;
        }
    }
}
