﻿using System.ServiceModel;
using System.ServiceModel.Channels;
using Curse.CloudServices.Client;
using Curse.LoadTests.Client.ClientLoginService;
using Curse.ServiceAuthentication.Models;

namespace Curse.LoadTests.Client.ServiceClients
{
    public class LoginWebClient : BaseServiceClient<LoginWebClient, IClientLoginService, ClientLoginServiceClient>
    {
        private const string LoginServiceAddress = "https://clientservice-v6.curse.opt/ClientLoginService.svc/Binary";
        private static readonly EndpointAddress Address = new EndpointAddress(LoginServiceAddress);
        private static readonly Binding Binding = BindingHelper.GetBinaryBinding(true);

        protected override ClientLoginServiceClient CreateClient()
        {
            // Create the client
            return new ClientLoginServiceClient(Binding, Address);
        }

        protected override bool HandleServiceFault<V>(FaultException ex)
        {
            return false;
        }

        private const string LocalEncryptionSeed = "31ED549B43318C9CFAE926ADE1720D2202C2DEFFAB06AE9D78FB6F16DF2D70A4";
        private static readonly StringCipher LocalCipher = new StringCipher(LocalEncryptionSeed);

        public static string EncryptLocalString(string value)
        {
            return LocalCipher.Encrypt(value);
        }
    }
}
