﻿using System;
using System.ServiceModel;
using System.ServiceModel.Channels;
using Curse.CloudServices.Client;
using Curse.Friends.Configuration.CurseVoiceService;

namespace Curse.LoadTests.Client.ServiceClients
{
    class VoiceWebClient : BaseServiceClient<VoiceWebClient,ICurseVoiceService,CurseVoiceServiceClient>
    {
        private const string VoiceWebServiceAddress = "https://voice-service.cursevoice.opt/CurseVoiceService.svc";
        private static readonly EndpointAddress Endpoint = new EndpointAddress(VoiceWebServiceAddress);
        private static readonly Binding Binding = BindingHelper.GetBasicHttpBinding(ServiceClientConfiguration.SslEnabled);

        /// <summary>
        /// This is needed for the base class implementation and should not be called manually
        /// </summary>
        public VoiceWebClient()
        {
        }

        private readonly int _userID;
        private readonly string _apiKey;
        private string _token;

        public VoiceWebClient(int userID, string apiKey=null)
        {
            _userID = userID;
            _apiKey = apiKey;
        }

        public void UpdateToken(string token)
        {
            _token = token;
        }

        protected override CurseVoiceServiceClient CreateClient()
        {
            if (_token == null)
            {
                throw new InvalidOperationException();
            }
            var client = new CurseVoiceServiceClient(Binding, Endpoint);

            CurrentToken = _token;
            client.ChannelFactory.Endpoint.Behaviors.Add(new AuthTokenExtension(new AuthenticationToken(_userID, _token, _apiKey)));
            return client;
        }

        protected override bool RenewToken()
        {
            return _token != null && _token == CurrentToken;
        }
    }
}
