﻿using System;
using System.ServiceModel;
using System.Threading;

namespace Curse.LoadTests.Contracts
{
    public static class ChannelExtensions
    {
        public static void UseChannel<T>(this ChannelFactory<T> factory, Action<T> action, int retries=2)
        {
            UseChannel(factory, c =>
            {
                action(c);
                return true;
            }, retries);
        }

        public static TRes UseChannel<T,TRes>(this ChannelFactory<T> factory, Func<T,TRes> func, int retries=2)
        {
            var attempts = 0;
            while (true)
            {
                IClientChannel channel = null;
                try
                {
                    var client = factory.CreateChannel();
                    channel = (IClientChannel)client;
                    return func(client);
                }
                catch
                {
                    if (channel != null)
                    {
                        channel.Abort();
                    }

                    if (attempts++ > retries)
                    {
                        throw;
                    }
                    else
                    {
                        Thread.Sleep(TimeSpan.FromSeconds(20));
                    }
                }
                finally
                {
                    if (channel != null)
                    {
                        channel.Dispose();
                    }
                }
            }
        }
    }
}
