﻿using System;
using System.ServiceModel;
using Curse.LoadTests.Contracts;

namespace Curse.LoadTests.Coordinator.Clients
{
    abstract class BaseClient
    {
        protected readonly string Host;
        protected readonly int UserStartIndex;
        protected readonly int UserEndIndex;

        private readonly ChannelFactory<IClientService> _channelFactory; 

        protected BaseClient(string host, int userStartIndex, int userEndIndex, EndpointAddress clientAddress)
        {
            Host = host;
            UserStartIndex = userStartIndex;
            UserEndIndex = userEndIndex;
            _channelFactory = new ChannelFactory<IClientService>(new BasicHttpBinding(), clientAddress);
        }

        public virtual void Start()
        {
            if (_channelFactory == null)
            {
                throw new InvalidOperationException();
            }

            _channelFactory.UseChannel(c => c.Start(UserStartIndex, UserEndIndex));
        }

        public virtual void Stop()
        {
            if (_channelFactory == null)
            {
                throw new InvalidOperationException();
            }

            _channelFactory.UseChannel(c => c.Stop());
        }
    }
}
