﻿using System;
using System.Linq;
using System.Management;
using System.ServiceModel;
using Curse.LoadTests.Contracts;

namespace Curse.LoadTests.Coordinator.Clients
{
    class ConsoleClient : BaseClient
    {
        private readonly uint _processID;

        public static ConsoleClient Create(string host, int userStartIndex, int userEndIndex)
        {
            var createArgs = new object[]
            {
                @"C:\Applications\CurseLoadTestClient\Curse.LoadTests.Client.exe",
                @"C:\Applications\CurseLoadTestClient",
                null,
                0
            };

            var remoteProcessClass = new ManagementClass(string.Format(@"\\{0}\root\cimv2:Win32_Process", host));
            var result = remoteProcessClass.InvokeMethod("Create", createArgs);
            if ((uint)result != 0)
            {
                // Error starting process!
                throw new InvalidOperationException("Failed to start remote process! " + result);
            }

            var processID = (uint)createArgs[3];
            var address = new EndpointAddress(string.Format("http://{0}/client-service/{1}", host, processID));

            return new ConsoleClient(host, userStartIndex, userEndIndex, address, processID);
        }

        private ConsoleClient(string host, int userStartIndex, int userEndIndex, EndpointAddress address, uint processID):base(host,userStartIndex,userEndIndex, address)
        {
            _processID = processID;
        }

        public void Terminate()
        {
            var searcher = new ManagementObjectSearcher(@"\\build05a-hsv\root\cimv2", string.Format("SELECT * FROM Win32_Process WHERE Handle='{0}'", _processID));
            var process = searcher.Get().Cast<ManagementObject>().FirstOrDefault();
            if (process != null)
            {
                process.InvokeMethod("Terminate", new object[] {1});
            }
        }


    }
}
