﻿using System;
using System.IO;
using System.Xml.Serialization;
using Curse.Logging;

namespace Curse.LoadTests.Monitor.Configuration
{
    public enum ConfigurationMode
    {
        Debug,
        LoadTesting,
    }

    [XmlType("Monitor")]
    public class LoadTestMonitorConfiguration
    {
        public static ConfigurationMode Mode { get; private set; }

        private static readonly LoadTestMonitorConfiguration _instance = null;

        public static LoadTestMonitorConfiguration Instance
        {
            get { return _instance; }
        }

        static LoadTestMonitorConfiguration()
        {
            
#if DEBUG
            Mode = ConfigurationMode.Debug;
#else
            Mode = ConfigurationMode.LoadTesting;
#endif
            // Try to load the config, based on the compilation mode

            Logger.Info("Current configuration is: " + Mode);
            
            var configPath = FindConfigPath();

            Logger.Info("Loading service configuration from: " + configPath);

            using (var reader = new StreamReader(configPath))
            {
                var dcs = new XmlSerializer(typeof(LoadTestMonitorConfiguration));
                _instance = (LoadTestMonitorConfiguration)dcs.Deserialize(reader);
            }

        }

        private static string FindConfigPath()
        {
            string configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Configuration", "Monitor." + Mode.ToString() + ".config");

            if (!File.Exists(configPath))
            {
                configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "bin", "Configuration", "Monitor." + Mode.ToString() + ".config");
            }

            if (!File.Exists(configPath))
            {
                throw new Exception("Configuration could not be loaded from '" + configPath + "'");
            }

            return configPath;
        }

        public void Save()
        {
            var configPath = FindConfigPath();

            using (var writer = new StreamWriter(configPath))
            {
                var dcs = new XmlSerializer(typeof(LoadTestMonitorConfiguration));
                dcs.Serialize(writer, this);
            }
        }

        [XmlElement]
        public string LoadTestReportingConnectionString { get; set; }

        [XmlElement]
        public string CentralLogServiceUrl { get; set; }

        [XmlElement]
        public string CentralServiceApiKey { get; set; }
    }
}
