﻿using System.ServiceModel;
using System.ServiceModel.Web;
using Curse.LoadTests.Statistics.Models;

namespace Curse.LoadTests.Monitor
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the interface name "ICurseLoadTestMonitor" in both code and config file together.
    [ServiceContract]
    public interface ILoadTestMonitor
    {
        [OperationContract(IsOneWay = true)]
        void UploadClientHostStatistics(string apiKey, ClientHostStats clientHostStats);

        [OperationContract(IsOneWay = true)]
        void UploadClientHostStatisticsJson(string apiKey, string serialized);

        [OperationContract]
        [WebGet(UriTemplate = "health-check")]
        string HealthCheck();
    }
}
