﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using Curse.LoadTests.Monitor.Configuration;
using Curse.LoadTests.Statistics.Models;
using Curse.Logging;
using Curse.Logging.Uploader;
using Newtonsoft.Json;

namespace Curse.LoadTests.Monitor
{
    // NOTE: You can use the "Rename" command on the "Refactor" menu to change the class name "CurseLoadTestMonitor" in code, svc and config file together.
    // NOTE: In order to launch WCF Test Client for testing this service, please select CurseLoadTestMonitor.svc or CurseLoadTestMonitor.svc.cs at the Solution Explorer and start debugging.
    public class LoadTestMonitor : ILoadTestMonitor
    {
        public void UploadClientHostStatistics(string apiKey, ClientHostStats clientHostStats)
        {
            try
            {
                if (!clientHostStats.ClientStatsByBehavior.Any())
                {
                    Logger.Warn("Load Test Statistics submitted without any data.");
                    return;
                }

                //UploadClientHostStatisticsJson(apiKey, clientHostStats);

                var loadTestTable = new DataTable();
                loadTestTable.Columns.Add("BeginTime", typeof(DateTime));
                loadTestTable.Columns.Add("EndTime", typeof(DateTime));
                loadTestTable.Columns.Add("RegionID", typeof(int));
                loadTestTable.Columns.Add("MachineName", typeof(string));
                loadTestTable.Columns.Add("Personality", typeof(string));
                loadTestTable.Columns.Add("Stats", typeof(string));

                loadTestTable.BeginLoadData();
                foreach (var personalityPair in clientHostStats.ClientStatsByBehavior)
                {
                    var row = loadTestTable.NewRow();
                    row["BeginTime"] = clientHostStats.BeginTime;
                    row["EndTime"] = clientHostStats.EndTime;
                    row["RegionID"] = clientHostStats.RegionID;
                    row["MachineName"] = clientHostStats.MachineName;
                    row["Personality"] = personalityPair.Key;
                    row["Stats"] = JsonConvert.SerializeObject(personalityPair.Value);

                    loadTestTable.Rows.Add(row);
                }

                using (var bulkCopy = new SqlBulkCopy(LoadTestMonitorConfiguration.Instance.LoadTestReportingConnectionString,
                    SqlBulkCopyOptions.TableLock))
                {
                    bulkCopy.BulkCopyTimeout = 300; //5 mins timeout
                    bulkCopy.DestinationTableName = "dbo.LoadTestPeriodicStats";
                    bulkCopy.WriteToServer(loadTestTable);
                }
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to write load test stats to the database.");
            }
        }

        public void UploadClientHostStatisticsJson(string apiKey, string serialized)
        {
            // TODO: Write reports to SQL06-dev.curse.us DB
        }

        public string HealthCheck()
        {
            return "Successful";
        }

        public static void Startup()
        {
            Logger.Init(new LoggerConfig(@"C:\Curse\CurseLoadTestMonitor\Logs") { MaxLogSize = Int32.MaxValue, LogRetainCount = 2 });
            LogUploader.Initialize(17, LoadTestMonitorConfiguration.Instance.CentralLogServiceUrl, LoadTestMonitorConfiguration.Instance.CentralServiceApiKey);
            Logger.Info("Starting...");
        }

        public static void Shutdown()
        {
            Logger.Info("Service Stopped!");
        }
    }
}
