﻿using Curse.Friends.Statistics;
using Curse.LoadTests.Enums;
using Curse.LoadTests.Statistics.Models;

namespace Curse.LoadTests.Statistics
{
    public class ClientStatTracker
    {
        public string ClientBehaviorProfileName;
        public int RegionID;

        public ClientStatTracker(string profileName, int regionID)
        {
            ClientBehaviorProfileName = profileName;
            RegionID = regionID;
        }

        private readonly EnumeratedStatCounter<TrackedEventType> _counters = new EnumeratedStatCounter<TrackedEventType>();
        public void TrackStatForEvent(TrackedEventType type)
        {
            _counters.Track(type);
        }

        public ClientStats GetSnapshot()
        {
            return new ClientStats
            {
                ClientBehaviorProfileName = ClientBehaviorProfileName,
                TrackedEvents = _counters.Values
            };
        }
    }
}
