﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Net.Mime;
using System.Reflection;
using System.Web;
using System.Web.Compilation;
using System.Web.Mvc;
using Curse.HealthMonitor.Deployer.Models;
using Ionic.Zip;

namespace Curse.HealthMonitor.Deployer.Controllers
{
    public class HomeController : Controller
    {
        [HttpGet]
        public ActionResult Index()
        {
            return View(new NodeModel());
        }

        [HttpPost]
        public ActionResult Index(NodeModel model)
        {
            // Publish the health monitor app to C:\Publish\HealthMonitor
            string path = "\"" + Path.Combine(AppDomain.CurrentDomain.BaseDirectory, @"..\Curse.HealthMonitor\Curse.HealthMonitor.csproj") + "\"";
            var p = new Process();
            p.StartInfo = new ProcessStartInfo(@"C:\Windows\Microsoft.NET\Framework64\v4.0.30319\msbuild.exe");
            p.StartInfo.Arguments = path + @" /p:DeployOnBuild=true /p:PublishProfile=Profile1.pubxml";
            p.Start();
            p.WaitForExit();

            // Zip it up
            using (ZipFile zip = new ZipFile())
            {
                zip.AddDirectory(@"C:\publish\HealthMonitor");
                zip.Save("HealthMonitor.zip");
            }

            // Deploy the health monitor based on the settings provided.
            string[] nodeLetters = model.NodeLetter.HasValue ? new[] {model.NodeLetter.Value.ToString().ToLower()} : Curse.MSBuild.WebFarmDeployTester.Constants.NodeLetters;
            Curse.MSBuild.WebFarmDeployTester.Program.DeployHealthMonitorToGroup(model.NodeNumber.Value, nodeLetters);

            return this.RedirectToAction("Index", "Home");
        }
    }
}