﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Curse.HealthMonitor
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            HealthCheckStatus status = HealthMonitorManager.Instance.CheckSite();
            if (status.IsSuccessful)
            {
                Response.Write(HealthMonitorManager.Instance.HostToMonitor + " responded with a " + status.ContentLength.ToString("n0") + " byte response in " + status.ResponseTime.TotalMilliseconds.ToString("n0") + " milliseconds");
                Response.Write(status.ResponseContent);
            }
            else
            {
                
                if (status.FailureMessage != null)
                {
                    Response.Write("Failed: " + status.FailureMessage);
                }
                else
                {
                    Response.Write(HealthMonitorManager.Instance.HostToMonitor + " failed to respond in a timely fashion!"); 
                }
                Response.StatusCode = 502;
                Response.Flush();
            }

        }
    }
}
