﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;
using System.DirectoryServices;
using Microsoft.Web.Administration;
using System.IO;
using System.Web.Hosting;

namespace Curse.HealthMonitor
{
    public class Global : System.Web.HttpApplication
    {

        void Application_Start(object sender, EventArgs e)
        {
            Logger.SetLogFilename = DateTime.UtcNow.Ticks + ".log";
            Logger.SetLogPath = @"C:\Curse\Logs\HealthMonitor";            
            Logger.SetLogLevel = ELogLevel.Error;
            Logger.Log("Application Started", ELogLevel.Info);

        }

        void Application_End(object sender, EventArgs e)
        {
            Logger.Log("Application Ended", ELogLevel.Info);
            try
            {
                ApplicationShutdownReason shutdownReason = HostingEnvironment.ShutdownReason;
                Logger.Log("Application Shutdown Reason: " + shutdownReason.ToString(), ELogLevel.Info);
            }
            catch (Exception ex)
            {
                Logger.Log("Unable to determine shutdown reason: " + ex.Message, ELogLevel.Info);                
            }                        
        }

        void Application_Error(object sender, EventArgs e)
        {
            // Code that runs when an unhandled error occurs

        }

        void Session_Start(object sender, EventArgs e)
        {
            // Code that runs when a new session is started

        }

        void Session_End(object sender, EventArgs e)
        {
            // Code that runs when a session ends. 
            // Note: The Session_End event is raised only when the sessionstate mode
            // is set to InProc in the Web.config file. If session mode is set to StateServer 
            // or SQLServer, the event is not raised.

        }

    }
}
