﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Mail;
using System.Web;

namespace Curse.HealthMonitor
{
    public static class SimpleMailUtility
    {

        private static MailAddress[] _mailAddresses = new[] { new MailAddress("health-check-alerts@curse.com"), };
        public static MailAddress[] MailAddresses
        {
            get { return _mailAddresses; }
            set { _mailAddresses = value; }
        }
        

        public static void SendMessage(string subject, string body)
        {
            var mailMessage = new MailMessage();
#if _DEBUG
            mailMessage.To.Add(new MailAddress("mcomperda@curse.com"));
#else
            foreach (var address in MailAddresses)
            {
                mailMessage.To.Add(address);
            }
#endif       
            mailMessage.From = new MailAddress("health-check-alerts@curse.com");
            mailMessage.Subject = subject;
            mailMessage.Body = body;
            mailMessage.IsBodyHtml = true;

            try
            {
                using (var client = new SmtpClient("mandrill.curse.us", 25))
                {                    
                    client.Credentials = new NetworkCredential("mcomperda@curse.com", "syVRRVZ-9EA569_mU2Xw8A");
                    client.Send(mailMessage);
                }
            }
            catch (Exception ex)
            {                
                Logger.Log("Unable to send email: " + ex.Message + ", Stack: " + ex.StackTrace, ELogLevel.Error);
            }
            
        }
    }
}