﻿using System;
using System.Collections.Generic;

namespace Curse.MSBuild.Chef.Tester
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                var nodes = SousChef.GetIISNodesForService(new[] { "dev", "iad", "dub", "sin" }, "notifications", false);
                foreach (var node in nodes)
                {
                    Console.WriteLine("[" + node.Environment + "] " + node.HostName + ": " + node.Name);
                }
            }
            catch (Exception)
            {
                return;
            }            

            Console.WriteLine("General Worker");
            try
            {
                var nodes = SousChef.GetWindowsNodesForService(new[] { "iad", "dub", "sin" }, "client-notifications-worker");
                foreach (var node in nodes)
                {
                    Console.WriteLine(node.Name);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
                return;
            }

            return;
            

            Console.WriteLine("TimeSeries");
            try
            {
                var nodes = SousChef.GetElasticNodesForEnvironments(new[] { "iad", "dub", "sin" }, "timeseries");
                foreach (var node in nodes)
                {
                    Console.WriteLine(node.Name);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
                return;
            }


            Console.WriteLine("General");
            try
            {
                var nodes = SousChef.GetElasticNodesForEnvironments(new[] { "iad", "dub", "sin" }, "general");
                foreach (var node in nodes)
                {
                    Console.WriteLine(node.Name);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
                return;
            }
            
            Console.ReadKey(true);
        }
    }
}
