﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Build.Framework;
using System.Xml.Linq;
using Microsoft.Build.Utilities;
using System.Collections;

namespace Curse.MSBuild.CobaltConfigParser
{
    public class CobaltConfigParser : ITask
    {


        public bool Execute()
        {
            _configDoc = XDocument.Load(CobaltConfigFile);
            if (_configDoc == null)
            {
                throw new Exception(string.Format("Can't load XML file {0}", CobaltConfigFile));
            }

            return true;

        }

        [Output]
        public ITaskItem[] ViewPaths
        {
            get
            {
                XElement pathHintsNode = _configDoc.Descendants("viewEngine").FirstOrDefault().Element("pathHints");

                IEnumerable<string> pathHints = pathHintsNode.Elements("pathHint").Attributes("value").Select(x => x.Value);

                IList<ITaskItem> pathHintItems = new List<ITaskItem>();

                foreach (string hint in pathHints)
                {
                    Hashtable metadata = new Hashtable();
                    metadata.Add("Name", hint);
                    ITaskItem hintItem = new TaskItem(hint, metadata);
                    pathHintItems.Add(hintItem);
                }
                return pathHintItems.ToArray();
                               
            }
        }

        private XDocument _configDoc;
        public IBuildEngine BuildEngine { get; set; }
        public ITaskHost HostObject { get; set; }

        #region Properties
        
        [Required]
        public string CobaltConfigFile { get; set; }

        #endregion
    }
}