﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.MSBuild.Deployment
{
    public class DeployStep
    {        
        private void WriteStepMessage()
        {
            Console.WriteLine("-------------------------------------------------------------------------------------");
            Console.WriteLine("Step " + _stepNumber + " of " + _steps.Count + ": " + _stepMessage);
            Console.Title = "Step " + _stepNumber + " of " + _steps.Count + ": " + _stepMessage;
            if (!_determinate())
            {
                Console.WriteLine("Skipping Step!");
            }
        }

        private int _stepNumber;
        private string _stepMessage;
        private Func<bool> _determinate;
        private Action _stepAction;

        public DeployStep(int stepNumber, string stepMessage, Func<bool> determinate, Action stepAction = null)
        {
            _stepNumber = stepNumber;
            _stepMessage = stepMessage;
            _determinate = determinate;
            _stepAction = stepAction;
        }

        public static void Initialize()
        {
            _steps.Clear();
        }

        private bool Run()
        {
            WriteStepMessage();
            try
            {
                if (_determinate())
                {
                    _stepAction();
                }
            }
            catch (AggregateException e)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                foreach (var ex in e.InnerExceptions)
                {
                    Console.WriteLine("Failed: " + ex.Message);
                    Console.WriteLine(ex.StackTrace);
                }
                Console.ResetColor();
                return false;
            }
            catch (Exception ex)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("Failed: " + ex.Message);
                Console.WriteLine(ex.StackTrace);
                Console.ResetColor();
                return false;
            }

            return true;
        }

        private static List<DeployStep> _steps = new List<DeployStep>();
        
        
        public static void RegisterStep(string stepMessage, Func<bool> determinate, Action stepAction = null)
        {
            DeployStep step = new DeployStep(_steps.Count + 1, stepMessage, determinate, stepAction);   
            _steps.Add(step);
        }

        public static bool RunAll()
        {
            foreach (var deployStep in _steps)
            {
                if (!deployStep.Run())
                {                    
                    return false;                    
                }
            }

            return true;
        }
       
    }
}
