﻿using System;
using System.Linq;

namespace Curse.MSBuild.Deployment
{
    public static class DeployUtils
    {
        public static string[] PromptServerNames(string[] fullServerList)
        {
            var res = PromptUser("Do you want to limit this deploy to a specific region? ([N]A, [E]U, [A]P, or ENTER for all )", new[] { ConsoleKey.Enter, ConsoleKey.N, ConsoleKey.E, ConsoleKey.A });

            Console.WriteLine("Limit this deploy to a specific node? (Enter the number and letter)");
            var nodeNumberVal = Console.ReadLine();

            var filteredServerNames = fullServerList;
            

            switch (res)
            {
                case ConsoleKey.N:
                    filteredServerNames = filteredServerNames.Where(p => p.Contains("iad")).ToArray();
                    break;                    

                case ConsoleKey.E:
                    filteredServerNames = filteredServerNames.Where(p => p.Contains("dub")).ToArray();
                    break;

                case ConsoleKey.A:
                    filteredServerNames = filteredServerNames.Where(p => p.Contains("sin")).ToArray();
                    break;
            }

            if (!string.IsNullOrEmpty(nodeNumberVal))
            {
                filteredServerNames = filteredServerNames.Where(p => p.Contains(nodeNumberVal)).ToArray();
            }

            return filteredServerNames;
        }

        public static ConsoleKey PromptUser(string promptText, ConsoleKey[] options)
        {

            Console.ForegroundColor = ConsoleColor.Cyan;
            Console.Write(promptText);
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.Write(" [");

            for (int i = 0; i < options.Length; i++)
            {
                if (i > 0)
                {
                    Console.Write("/");
                }
                Console.Write(options[i].ToString());
            }
            Console.WriteLine("]");
            Console.ResetColor();
            var resp = Console.ReadKey(true);


            while (true)
            {
                if (options.Contains(resp.Key))
                {
                    break;
                }

                Console.WriteLine("Unknown Response. Please enter a valid option.");
                resp = Console.ReadKey(true);
            }

            return resp.Key;
        }

        public static string[] GetChefEnvironments(string compilationMode)
        {
            switch (compilationMode)
            {
                case "Staging":
                    return new[] { "dev" };
                case "Release":
                    return new[] { "iad", "dub", "sin" };
                default:
                    return new string[0];
            }
        }
    }
}
