﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace Curse.MSBuild.Deployment
{
    public static class PathHelper
    {
        public static string GetRemoteTempFolderPath(string nodeName, string version, bool returnLocalPath)
        {
            string localPath = @"c:\Windows\Temp\Deploys\" + version;
            string uncPath = @"\\" + nodeName + @"\c$\Windows\Temp\Deploys\" + version;
            DirectoryInfo di = new DirectoryInfo(uncPath);
            if (!di.Exists)
            {
                di.Create();
            }

            return returnLocalPath ? localPath : uncPath;
        }

        public static string GetRemoteTempFilePath(string zipFilePath, string nodeName, string version, bool useLocal)
        {
            FileInfo fi = new FileInfo(zipFilePath);
            return GetRemoteTempFolderPath(nodeName, version, useLocal) + @"\" + fi.Name;
        }

        
    }
}
