﻿using System;
using Amazon;
using Amazon.Runtime.CredentialManagement;
using Amazon.S3;
using Amazon.S3.Model;
using Twitch.Arcana;

namespace Curse.MSBuild.Deployment
{
    public class S3Helper
    {
        private static AmazonS3Client _s3Client;        

        public static void Initialize()
        {
            if (_s3Client != null)
            {
                return;
            }

            var credsFile = new NetSDKCredentialsFile();
            CredentialProfile profile = null;
            credsFile.TryGetProfile("assume-curse", out profile);
            var creds = profile.GetAWSCredentials(credsFile);            
            _s3Client = new AmazonS3Client(creds, RegionEndpoint.USEast1);
        }

        public static string SaveToS3(string key, string filePath)
        {
            Initialize();

            var awsBucket = Properties.Settings.Default.S3_Bucket;

            _s3Client.PutObject(new PutObjectRequest
            {
                BucketName = awsBucket,
                FilePath = filePath,
                Key = key,
            });

            var url = _s3Client.GetPreSignedURL(new GetPreSignedUrlRequest
            {
                BucketName = awsBucket,
                Key = key,
                Expires = DateTime.Now.AddHours(1),
            });

            return url;
        }

        public static void CopyWithinS3(string src, string dest)
        {
            Initialize();

            var awsBucket = Properties.Settings.Default.S3_Bucket;

            _s3Client.CopyObject(new CopyObjectRequest
            {
                SourceBucket = awsBucket,
                SourceKey = src,
                DestinationBucket = awsBucket,
                DestinationKey = dest,
            });
        }     
    }
}
