﻿using System.Data.SqlClient;
using System.Diagnostics;
using System.Diagnostics.CodeAnalysis;
using System.Management.Automation;
using System.Security;
using Microsoft.Build.Framework;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Management.Automation.Runspaces;

namespace Curse.MSBuild.Deployment
{
    public class WindowsServerFirewallDeploy : ITask
    {
        public IBuildEngine BuildEngine { get; set; }
        public ITaskHost HostObject { get; set; }


        public bool Execute()
        {
            DeployStep.Initialize();

            DeployStep.RegisterStep("Validating Configuration", () => true, () =>
            {
                RemoteScriptHelper.Initialize(Username, Password);
            });

            DeployStep.RegisterStep("Whitelist Remote Servers", () => true, () =>
            {
                // Query list of servers
                var ipList = new List<string>();

                using (var conn = new SqlConnection("Data Source=sql07-live.curse.us;Initial Catalog=CurseVoice;Integrated Security=True;MultiSubnetFailover=true"))
                {
                    conn.Open();
                    using (var cmd = conn.CreateCommand())
                    {
                        cmd.CommandText = "SELECT [IPAddress] from [VoiceHost]";

                        using (var reader = cmd.ExecuteReader())
                        {
                            while (reader.Read())
                            {
                                ipList.Add(reader.GetString(0));
                            }
                        }
                    }
                }

                foreach (var ipAddress in ipList)
                {
                    Console.WriteLine("White listing '" + ipAddress + "'...");
                    using (var ps = PowerShell.Create())
                    {
                        ps.AddScript(@"Set-Item wsman:\localhost\Client\TrustedHosts " + ipAddress + " -Concatenate -Force");
                        var result = ps.Invoke();
                    }
                }
            });

            DeployStep.RegisterStep("", () => true, () =>
            {
                foreach (var node in ServerNames)
                {
                    Console.WriteLine("Deploying to " + node);

                    using (var runspace = RemoteScriptHelper.CreateRunspace(node))
                    {

                        foreach (var port in Ports)
                        {
                            RemoteScriptHelper.ExecuteRemoteScript(runspace,
                                "netsh advfirewall firewall delete rule name=\"Curse Voice - TCP Port " + port + "\"");
                            RemoteScriptHelper.ExecuteRemoteScript(runspace,
                                "netsh advfirewall firewall add rule name=\"Curse Voice - TCP Port " + port + "\" dir=in action=allow protocol=tcp localport=" + port);

                            RemoteScriptHelper.ExecuteRemoteScript(runspace,
                                "netsh advfirewall firewall delete rule name=\"Curse Voice - UDP Port " + port + "\"");
                            RemoteScriptHelper.ExecuteRemoteScript(runspace,
                                "netsh advfirewall firewall add rule name=\"Curse Voice - UDP Port " + port + "\" dir=in action=allow protocol=udp localport=" + port);
                        }
                    }
                }
            });


            DeployStep.RunAll();
            return true;

        }

        [Required]
        public int[] Ports { get; set; }

        [Required]
        public string[] ServerNames { get; set; }

        [Required]
        public string Username { get; set; }

        [Required]
        public string Password { get; set; }

    }
}
