﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;

namespace Curse.MSBuild.Deployment
{
    public class WindowsServiceHelper
    {
        public static bool HasService(string machineName, string serviceName)
        {
            var filename = @"C:\Program Files (x86)\PsExec\PsService.exe";

            if (!IsProcessFileExists(filename))
            {
                throw new Exception("Missing file - "+filename);
            }
            var process = new Process();
            process.StartInfo.FileName = filename;
            process.StartInfo.Arguments = string.Format(@"/accepteula \\{0} query {1}", machineName, serviceName);
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.RedirectStandardError = true;
            process.StartInfo.UseShellExecute = false;
            process.Start();
            process.WaitForExit();
            var output = process.StandardOutput.ReadToEnd();
            return output.ToUpper().Contains("SERVICE_NAME");            
        }

        public static bool IsServiceRunning(string machineName, string serviceName)
        {
            var filename = @"C:\Program Files (x86)\PsExec\PsService.exe";

            if (!IsProcessFileExists(filename))
            {
                throw new Exception("Missing file - " + filename);
            }
            var process = new Process();
            process.StartInfo.FileName = filename;
            process.StartInfo.Arguments = string.Format(@"/accepteula \\{0} query {1}", machineName, serviceName);
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.RedirectStandardError = true;
            process.StartInfo.UseShellExecute = false;
            process.Start();
            process.WaitForExit();
            var output = process.StandardOutput.ReadToEnd();
            return (output.ToUpper().Contains("SERVICE_NAME") && output.ToUpper().Contains("RUNNING"));
        }

        public static bool ToggleServiceState(string machineName, string serviceName, string state)
        {
            var filename = @"C:\Program Files (x86)\PsExec\psexec.exe";
            if (!IsProcessFileExists(filename))
            {
                throw new Exception("Missing file - " + filename);
            }
            var process = new Process();
            process.StartInfo.FileName = filename;
            process.StartInfo.Arguments = string.Format(@"/accepteula -s -h -n 10 \\{0} net {1} /y {2}", machineName, state, serviceName);
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardError = true;
            process.Start();
            var error = process.StandardError.ReadToEnd();
            process.WaitForExit();
            if (state == "stop")
            {
                return process.ExitCode == 0 || error.ToLower().Contains("not started");
            }
            return process.ExitCode == 0 || error.ToLower().Contains("already been started");
        }

        public static bool InstallService(string machineName, string serviceName, string executablePath, bool redirectOutput=false)
        {
            var process = new Process();
            process.StartInfo.FileName = @"C:\Program Files (x86)\PsExec\psexec.exe";
            process.StartInfo.Arguments = string.Format(@"/accepteula -s -h -n 10 \\{0} ""{1}"" ""{2}""", machineName, GetInstallUtilPath(), executablePath);
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardOutput = redirectOutput;
            process.StartInfo.RedirectStandardError = redirectOutput;
            process.Start();
            process.WaitForExit();
            return process.ExitCode == 0;
        }

        public static bool UninstallService(string machineName, string serviceName, string executablePath, bool redirectOutput=false)
        {
            var process = new Process();
            process.StartInfo.FileName = @"C:\Program Files (x86)\PsExec\psexec.exe";
            process.StartInfo.Arguments = string.Format(@"/accepteula -s -h -n 10 \\{0} ""{1}"" /u ""{2}""", machineName,
                GetInstallUtilPath(),
                executablePath);
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardError = redirectOutput;
            process.StartInfo.RedirectStandardOutput = redirectOutput;
            process.Start();
            process.WaitForExit();
            return process.ExitCode == 0;
        }

        private static string GetInstallUtilPath()
        {
            return Path.Combine(System.Runtime.InteropServices.RuntimeEnvironment.GetRuntimeDirectory(), "installutil.exe");
        }

        private static bool IsProcessFileExists(string filename)
        {
            var fi = new FileInfo(filename);
            if (!fi.Exists)
            {
                Console.WriteLine(@"You are missing a local copy of PsExec. Please put it at " + filename);
                return false;
            }
            return true;
        }
    }
}
