﻿using System.Management.Automation.Runspaces;
using Ionic.Zip;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;

namespace Curse.MSBuild.Deployment
{
    public static class ZipHelper
    {
        public static void CreateZip(string sourceFolder, string destinationFile)
        {
            using (ZipFile zipFile = new ZipFile())
            {
                zipFile.ParallelDeflateThreshold = -1;
                Console.Write("Adding directory to zip: " + sourceFolder + "...");
                zipFile.AddDirectory(sourceFolder);
                Console.WriteLine("Done");
                Console.Write("Saving zip to: " + destinationFile + "...");
                if (!Directory.Exists(Path.GetDirectoryName(destinationFile)))
                {
                    Directory.CreateDirectory(Path.GetDirectoryName(destinationFile));
                }
                zipFile.Save(destinationFile);
                Console.WriteLine("Done");
            }
        }

        public static void CopyZipToTemp(string zipFilePath, string nodeName, string version)
        {

            // Copy to the first web node's temp folder                        
            var fi = new FileInfo(zipFilePath);
            var destinationFilePath = PathHelper.GetRemoteTempFilePath(zipFilePath, nodeName, version, false);            
            fi.CopyTo(destinationFilePath, true);
        }

        private static void EnsureUnzipExists(string nodeName, string unzipExePath = null)
        {
            //Console.WriteLine("Skipping unzip.exe copy!");
            return;

            // Ensure the remote server has unzip.exe
            var uncPath = @"\\" + nodeName + @"\c$\windows\system32\unzip.exe";
            Console.WriteLine("Ensuring remote server has unzip.exe...");

            try
            {                
                
                if (File.Exists(uncPath))
                {
                    Console.WriteLine("Unzip exists!");
                    return;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Unable to determine if server has unzip.exe: " + ex.Message + ". Path: " + uncPath);
            }

            try
            {
                Console.Write("Copying unzip.exe to remote server...");
                
                if (string.IsNullOrEmpty(unzipExePath))
                {
                    unzipExePath = @"C:\Projects\DeployTools\Assemblies\unzip.exe";
                }

                File.Copy(unzipExePath, uncPath);                                
                Console.WriteLine("Done");
            }
            catch (Exception ex)
            {
                Console.WriteLine("Totally failed to copy unzip: " + ex.Message);
            }
        }

        public static void UnzipRemotely(string sourceFile, string destinationPath, string nodeName, string unzipExePath = null)
        {
            EnsureUnzipExists(nodeName, unzipExePath);
            var process = new Process();
            process.StartInfo.FileName = @"C:\Program Files (x86)\PsExec\psexec.exe";
            process.StartInfo.Arguments = string.Format(@"/accepteula -s -h -n 10 \\{0} unzip.exe -o -qq ""{1}"" -d ""{2}""", nodeName, sourceFile, destinationPath);
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardOutput = true;

            try
            {
                process.Start();
                process.WaitForExit();
            }
            catch (Exception ex)
            {
                Console.WriteLine("Check if PsExec is installed at this path " + process.StartInfo.FileName);
                throw ex;
            }
           
           
          
            
            if (process.ExitCode != 0)
            {
                throw new Exception("Failed to unzip!");
            }

            
        }

        public static void UnzipRemotelyWithPowershell(Runspace runspace, string sourceFile, string destinationPath, string nodeName, string unzipExePath = null)
        {
            EnsureUnzipExists(nodeName, unzipExePath);
            RemoteScriptHelper.ExecuteRemoteScript(runspace, string.Format(@"unzip.exe -o -qq ""{0}"" -d ""{1}""", sourceFile, destinationPath));
        }
    }
}
