﻿using System;
using System.Collections.Generic;
using Microsoft.Build.Framework;
using System.Collections;
using System.IO;

namespace Curse.MSBuild
{
    /// <summary>
    /// This task is to make sure that we don't erroneously use $() instead of jQuery() in JS code for 3rd party websites, as this
    /// breaks them if they use other javascript libraries such as prototype.
    /// </summary>
    public class JQuerySanityCheck : ITask
    {
        static List<string> FilesToCheck = new List<string>
        {
            "Content/js/Libs/htmldiff.js",
            "Content/js/Libs/jquery.dbTooltip.js",
            "Content/js/Azeroth/Azeroth.Tooltip.js"
        };

        public bool Execute()
        {
            foreach (string file in FilesToCheck)
            {
                if (!File.Exists(file))
                {
                    BuildEngine.LogErrorEvent(new BuildErrorEventArgs("jQuery check", "while trying to open file", file, 0, 0, 0, 0, "The file doesn't exist.", null, null));
                    return false;
                }

                int lineNumber = 0;

                BuildEngine.LogMessageEvent(new BuildMessageEventArgs("jQuery $() usage check running on file: " + file, null, null, MessageImportance.Normal));
                foreach (string line in File.ReadAllLines(file))
                {
                    ++lineNumber;

                    if (line.Contains("$("))
                    {
                        BuildEngine.LogErrorEvent(new BuildErrorEventArgs("jQuery", "while checking for $() usage", file, lineNumber, 0, 0, 0, "Usage of $(...) was detected inside 3rd party Javascript files. Replace it with jQuery() before continuing with the deploy.", null, null));
                        return false;
                    }
                }
            }

            return true;
        }

        public IBuildEngine BuildEngine { get; set; }
        public ITaskHost HostObject { get; set; }
    }
}