﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Build.Framework;
using Microsoft.Build.Utilities;
using System.Xml;
using System.Xml.Linq;
using System.IO;
using System.Globalization;
using System.Net;

namespace Curse.MSBuild.NewRelic
{
    public class Deployment : Task
    {
        #region Properties

        /// <summary>
        /// The private API key to use to authenticate with New Relic
        /// </summary>
        [Required]
        public string ApiKey { get; set; }

        /// <summary>
        /// The name of the application.  Either the name or the id is required
        /// </summary>
        public string ApplicationName { get; set; }

        /// <summary>
        /// The ID of the application.  Either the name or the id is required
        /// </summary>
        public string ApplicationID { get; set; }

        /// <summary>
        /// Text annotation of the deployment
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// List of Changes  for this deployment
        /// </summary>
        public string ChangeLog { get; set; }

        /// <summary>
        /// The user performing the deployment
        /// </summary>
        public string User { get; set; }

        /// <summary>
        /// The api url to connect to
        /// </summary>
        public string ApiUrl { get; set; }

        #endregion
        
        public Deployment()
        {
            ApiUrl = "https://rpm.newrelic.com/deployments.xml";
        }
        public override bool Execute()
        {
            if (string.IsNullOrEmpty(ApplicationName) && string.IsNullOrEmpty(ApplicationID))
            {
                throw new ArgumentNullException("ApplicationName or ApplicationID must be specified");
            }

            string paramStr = string.Join("&", RequestParameters.ToArray());
            byte[] buffer = Encoding.ASCII.GetBytes(paramStr);

            HttpWebRequest postRequest = (HttpWebRequest)WebRequest.Create(ApiUrl);
            postRequest.Method = "POST";
            postRequest.ContentType ="application/x-www-form-urlencoded";
            postRequest.ContentLength = buffer.Length;
            postRequest.Headers.Add("x-api-key", ApiKey);

            Stream postData = postRequest.GetRequestStream();
            postData.Write(buffer, 0, buffer.Length);
            postData.Close();

            HttpWebResponse postResponse = (HttpWebResponse)postRequest.GetResponse();
            Console.WriteLine(postResponse.StatusCode);
            Console.WriteLine(postResponse.Server);
           
            Stream responseStream = postResponse.GetResponseStream();
            StreamReader reader = new StreamReader(responseStream);
            string textResponse = reader.ReadToEnd();
            Console.WriteLine(textResponse);

            return true;
        }

        private IEnumerable<string> RequestParameters {
            get {
                if (!string.IsNullOrEmpty(ApplicationName)) {
                    yield return GetParamStr("app_name", ApplicationName);
                }
                if (!string.IsNullOrEmpty(ApplicationName)) {
                    yield return GetParamStr("application_id", ApplicationID);
                }
                if (!string.IsNullOrEmpty(ApplicationName)) {
                    yield return GetParamStr("description", Description);
                }
                if (!string.IsNullOrEmpty(ApplicationName)) {
                    yield return GetParamStr("changelog", ChangeLog);
                }
                if (!string.IsNullOrEmpty(ApplicationName)) {
                    yield return GetParamStr("user", User);
                }
            }
        }

        private string GetParamStr(string newRelicName, string value) {
            return string.Format("deployment[{0}]={1}", newRelicName, value);
        }
         
    }
}
