﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace Curse.MSBuild.Packer
{
    public static class FileCopier
    {

        public static bool CopyFiles(string[] inputFiles, string OutputFileName)
        {
            foreach (string inputFile in inputFiles)
            {
                List<FileInfo> sourceFiles = new List<FileInfo>();
                DirectoryInfo sourceDirectory = new DirectoryInfo(inputFile);
                if (!sourceDirectory.Exists)
                {
                    Console.WriteLine("Folder not found: '{0}'\n", sourceDirectory.FullName);
                    return false;
                }

                try
                {
                    sourceFiles.AddRange(sourceDirectory.GetFiles("*.*", SearchOption.AllDirectories));
                }
                catch (Exception ex)
                {
                    Console.Write(ex.Message);
                    return false;
                }
                sourceFiles.RemoveAll(p => p.DirectoryName.Contains(".svn"));

                foreach (FileInfo sourceFile in sourceFiles)
                {                    
                    string relativePath = sourceFile.FullName.Substring(sourceDirectory.FullName.Length);                 
                    try
                    {
                        DirectoryInfo di = new DirectoryInfo(Path.GetDirectoryName(OutputFileName + relativePath));
                        if (!di.Exists)
                        {
                            di.Create();
                        }
                        sourceFile.CopyTo(OutputFileName + relativePath, true);
                    }
                    catch (Exception ex)
                    {
                        Console.Write(ex.Message);
                        return false;
                    }
                }
            }



            return true;
        }
    }
}
