﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Web;

namespace Curse.MSBuild.Packer
{
    public static class GoogleClosure
    {
        private static readonly string Url = "http://closure-compiler.appspot.com/compile";
        private static readonly string TextFormat = "js_code={0}&output_format=text&output_info=compiled_code&compilation_level={1}";

        public static string Minify(string script, string compilationLevel)
        {
            WebClient client = new WebClient();
            client.Headers.Add("content-type", "application/x-www-form-urlencoded");
            string text = string.Format(TextFormat, HttpUtility.UrlEncode(script), HttpUtility.UrlEncode(compilationLevel));
            return client.UploadString(Url, text);
        }

        public static string MinifyWhitespace(string script)
        {
            return Minify(script, "WHITESPACE_ONLY");
        }

        public static string MinifySimple(string script)
        {
            return Minify(script, "SIMPLE_OPTIMIZATIONS");
        }

        public static string MinifyAdvanced(string script)
        {
            return Minify(script, "ADVANCED_OPTIMIZATIONS");
        }
    }
}
